/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.core;

import io.fabric8.etcd.api.Response;
import io.fabric8.etcd.core.ImmutableNode;

public class ImmutableResponse
implements Response<ImmutableNode> {
    public final String action;
    public final ImmutableNode node;
    public final ImmutableNode prevNode;
    public final int errorCode;
    public final String message;
    public final String cause;
    public final int errorIndex;

    public ImmutableResponse(Response response) {
        this.action = response.getAction();
        this.node = response.getNode() != null ? new ImmutableNode(response.getNode()) : null;
        this.prevNode = response.getPrevNode() != null ? new ImmutableNode(response.getPrevNode()) : null;
        this.errorCode = response.getErrorCode();
        this.message = response.getMessage();
        this.cause = response.getCause();
        this.errorIndex = response.getErrorIndex();
    }

    public ImmutableResponse(String action, ImmutableNode node, ImmutableNode prevNode, int errorCode, String message, String cause, int errorIndex) {
        this.action = action;
        this.node = node;
        this.prevNode = prevNode;
        this.errorCode = errorCode;
        this.message = message;
        this.cause = cause;
        this.errorIndex = errorIndex;
    }

    public String getAction() {
        return this.action;
    }

    public ImmutableNode getNode() {
        return this.node;
    }

    public ImmutableNode getPrevNode() {
        return this.prevNode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public String toString() {
        return "ImmutableResponse{action='" + this.action + '\'' + ", node=" + this.node + ", prevNode=" + this.prevNode + ", errorCode=" + this.errorCode + ", message='" + this.message + '\'' + ", cause='" + this.cause + '\'' + ", errorIndex=" + this.errorIndex + '}';
    }
}

