/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.impl.dsl;

import io.fabric8.etcd.api.Keys;
import io.fabric8.etcd.api.Response;
import io.fabric8.etcd.core.Operation;
import io.fabric8.etcd.core.OperationContext;
import io.fabric8.etcd.core.SynchronousExecution;
import io.fabric8.etcd.dsl.SetDataBuilder;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class SetDataImpl
implements Operation {
    private final String key;
    private final String value;
    private final boolean dir;
    private final String prevValue;
    private final int prevIndex;
    private final boolean prevExists;
    private final int ttl;
    private final boolean ordered;

    public SetDataImpl(String key, String value, boolean dir, String prevValue, int prevIndex, boolean prevExists, int ttl, boolean ordered) {
        this.key = key;
        this.value = value;
        this.dir = dir;
        this.prevValue = prevValue;
        this.prevIndex = prevIndex;
        this.prevExists = prevExists;
        this.ttl = ttl;
        this.ordered = ordered;
    }

    @Override
    public HttpUriRequest createRequest(OperationContext context) {
        try {
            URIBuilder builder = new URIBuilder(context.getBaseUri()).setPath(Keys.makeKey((String)this.key)).addParameter("value", this.value).addParameter("dir", String.valueOf(this.dir)).addParameter("ordered", String.valueOf(this.ordered)).addParameter("prevExists", String.valueOf(this.prevExists));
            if (this.ttl >= 0) {
                builder = builder.addParameter("ttl", String.valueOf(this.ttl));
            }
            if (this.prevValue != null) {
                builder = builder.addParameter("prevValue", this.prevValue).addParameter("prevIndex", String.valueOf(this.prevIndex));
            }
            return new HttpPut(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements SetDataBuilder {
        private final SynchronousExecution execution = new SynchronousExecution();
        private final OperationContext context;
        private String value;
        private boolean dir;
        private String prevValue;
        private int prevIndex;
        private boolean prevExists;
        private int ttl = -1;
        private boolean ordered;

        public Builder(OperationContext context) {
            this.context = context;
        }

        public Response forKey(String key) {
            return this.execution.execute(this.context, new SetDataImpl(key, this.value, this.dir, this.prevValue, this.prevIndex, this.prevExists, this.ttl, this.ordered));
        }

        public SetDataBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SetDataBuilder prevValue(String prevValue) {
            this.prevValue = prevValue;
            return this;
        }

        public SetDataBuilder prevIndex(int prevIndex) {
            this.prevIndex = prevIndex;
            return this;
        }

        public SetDataBuilder prevExists() {
            this.prevExists = true;
            return this;
        }

        public SetDataBuilder dir() {
            this.dir = true;
            return this;
        }

        public SetDataBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public SetDataBuilder ordered() {
            this.ordered = true;
            return this;
        }
    }
}

