/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.impl.dsl;

import io.fabric8.etcd.api.Keys;
import io.fabric8.etcd.api.Response;
import io.fabric8.etcd.core.Operation;
import io.fabric8.etcd.core.OperationContext;
import io.fabric8.etcd.core.SynchronousExecution;
import io.fabric8.etcd.dsl.DeleteDataBuilder;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class DeleteDataImpl
implements Operation {
    private final String key;
    private final boolean dir;
    private final String prevValue;
    private final int prevIndex;
    private final boolean prevExists;
    private final boolean recursive;

    public DeleteDataImpl(String key, boolean dir, String prevValue, int prevIndex, boolean prevExists, boolean recursive) {
        this.key = key;
        this.dir = dir;
        this.prevValue = prevValue;
        this.prevIndex = prevIndex;
        this.prevExists = prevExists;
        this.recursive = recursive;
    }

    @Override
    public HttpUriRequest createRequest(OperationContext context) {
        try {
            URIBuilder builder = new URIBuilder(context.getBaseUri()).setPath(Keys.makeKey((String)this.key)).addParameter("dir", String.valueOf(this.dir)).addParameter("recursive", String.valueOf(this.recursive)).addParameter("prevExists", String.valueOf(this.prevExists));
            if (this.prevValue != null) {
                builder = builder.addParameter("prevValue", this.prevValue).addParameter("prevIndex", String.valueOf(this.prevIndex));
            }
            return new HttpDelete(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements DeleteDataBuilder {
        private final SynchronousExecution execution = new SynchronousExecution();
        private final OperationContext context;
        private String key;
        private boolean dir;
        private String prevValue;
        private int prevIndex;
        private boolean prevExists;
        private boolean recursive;

        public Builder(OperationContext context) {
            this.context = context;
        }

        public Response forKey(String key) {
            return this.execution.execute(this.context, new DeleteDataImpl(key, this.dir, this.prevValue, this.prevIndex, this.prevExists, this.recursive));
        }

        public Builder dir() {
            this.dir = true;
            return this;
        }

        public Builder prevValue(String prevValue) {
            this.prevValue = prevValue;
            return this;
        }

        public Builder prevIndex(int prevIndex) {
            this.prevIndex = prevIndex;
            return this;
        }

        public Builder prevExists() {
            this.prevExists = this.prevExists;
            return this;
        }

        public Builder recursive() {
            this.recursive = true;
            return this;
        }
    }
}

