/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.core;

import io.fabric8.etcd.api.Builder;
import io.fabric8.etcd.api.Node;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ImmutableNode
implements Node<ImmutableNode> {
    private final String key;
    private final long createdIndex;
    private final long modifiedIndex;
    private final String value;
    private final String expiration;
    private final int ttl;
    private final Set<ImmutableNode> nodes;
    private final boolean dir;

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    public ImmutableNode(Node<?> node) {
        this.key = node.getKey();
        this.createdIndex = node.getCreatedIndex();
        this.modifiedIndex = node.getModifiedIndex();
        this.value = node.getValue();
        this.expiration = node.getExpiration();
        this.ttl = node.getTtl();
        LinkedHashSet<ImmutableNode> transformedNodes = new LinkedHashSet<ImmutableNode>();
        if (node.getNodes() != null) {
            for (Node n : node.getNodes()) {
                transformedNodes.add(new ImmutableNode(n));
            }
        }
        this.nodes = Collections.unmodifiableSet(transformedNodes);
        this.dir = node.isDir();
    }

    public ImmutableNode(String key, long createdIndex, long modifiedIndex, String value, String expiration, int ttl, Set<ImmutableNode> nodes, boolean dir) {
        this.key = key;
        this.createdIndex = createdIndex;
        this.modifiedIndex = modifiedIndex;
        this.value = value;
        this.expiration = expiration;
        this.ttl = ttl;
        this.nodes = nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
        this.dir = dir;
    }

    public String getKey() {
        return this.key;
    }

    public long getCreatedIndex() {
        return this.createdIndex;
    }

    public long getModifiedIndex() {
        return this.modifiedIndex;
    }

    public String getValue() {
        return this.value;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public int getTtl() {
        return this.ttl;
    }

    public Set<ImmutableNode> getNodes() {
        return this.nodes;
    }

    public boolean isDir() {
        return this.dir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNode node = (ImmutableNode)o;
        if (this.createdIndex != node.createdIndex) {
            return false;
        }
        if (this.modifiedIndex != node.modifiedIndex) {
            return false;
        }
        if (this.key != null ? !this.key.equals(node.key) : node.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(node.value) : node.value != null);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "ImmutableNode{key='" + this.key + '\'' + ", createdIndex=" + this.createdIndex + ", modifiedIndex=" + this.modifiedIndex + ", value='" + this.value + '\'' + ", expiration='" + this.expiration + '\'' + ", ttl=" + this.ttl + ", nodes=" + this.nodes + ", dir=" + this.dir + '}';
    }

    public static class NodeBuilder
    implements Builder<ImmutableNode> {
        private String key;
        private long createdIndex;
        private long modifiedIndex;
        private String value;
        private String expiration;
        private int ttl;
        private Set<ImmutableNode> nodes = new LinkedHashSet<ImmutableNode>();
        private boolean dir;

        public NodeBuilder key(String key) {
            this.key = key;
            return this;
        }

        public NodeBuilder createIndex(long createdIndex) {
            this.createdIndex = createdIndex;
            return this;
        }

        public NodeBuilder modifiedIndex(long modifiedIndex) {
            this.modifiedIndex = modifiedIndex;
            return this;
        }

        public NodeBuilder value(String value) {
            this.value = value;
            return this;
        }

        public NodeBuilder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public NodeBuilder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public NodeBuilder nodes(Set<ImmutableNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public NodeBuilder addNode(ImmutableNode node) {
            this.nodes.add(node);
            return this;
        }

        NodeBuilder dir(boolean dir) {
            this.dir = dir;
            return this;
        }

        public ImmutableNode build() {
            return new ImmutableNode(this.key, this.createdIndex, this.modifiedIndex, this.value, this.expiration, this.ttl, this.nodes, this.nodes.size() > 0 || this.dir);
        }
    }
}

