/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.etcd.core;

import com.google.common.io.Closeables;
import io.fabric8.etcd.api.EtcdClient;
import io.fabric8.etcd.api.ResponseReader;
import io.fabric8.etcd.core.OperationContext;
import io.fabric8.etcd.core.OperationContextImpl;
import io.fabric8.etcd.core.ToResponse;
import io.fabric8.etcd.dsl.DeleteDataBuilder;
import io.fabric8.etcd.dsl.GetDataBuilder;
import io.fabric8.etcd.dsl.SetDataBuilder;
import io.fabric8.etcd.impl.dsl.DeleteDataImpl;
import io.fabric8.etcd.impl.dsl.GetDataImpl;
import io.fabric8.etcd.impl.dsl.SetDataImpl;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;

public class EtcdClientImpl
implements EtcdClient {
    private final OperationContext context;
    private final CloseableHttpAsyncClient client = HttpAsyncClients.custom().build();

    public EtcdClientImpl(URI baseUri, ResponseReader responseReader) {
        this.context = new OperationContextImpl(baseUri, (HttpAsyncClient)this.client, new ToResponse(responseReader));
    }

    public void start() {
        this.client.start();
    }

    public void stop() {
        try {
            Closeables.close((Closeable)this.client, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GetDataBuilder getData() {
        return new GetDataImpl.Builder(this.context);
    }

    public SetDataBuilder setData() {
        return new SetDataImpl.Builder(this.context);
    }

    public DeleteDataBuilder delete() {
        return new DeleteDataImpl.Builder(this.context);
    }

    public static class Builder
    implements io.fabric8.etcd.api.Builder<EtcdClientImpl> {
        private URI baseUri;
        private ResponseReader responseReader;

        public Builder baseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder responseReader(ResponseReader responseReader) {
            this.responseReader = responseReader;
            return this;
        }

        public EtcdClientImpl build() {
            return new EtcdClientImpl(this.baseUri, this.responseReader);
        }
    }
}

