/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.wait.WaitChecker;

public class ExitCodeChecker
implements WaitChecker {
    private final int exitCodeExpected;
    private final String containerId;
    private final QueryService queryService;

    public ExitCodeChecker(int exitCodeExpected, QueryService queryService, String containerId) {
        this.exitCodeExpected = exitCodeExpected;
        this.containerId = containerId;
        this.queryService = queryService;
    }

    @Override
    public boolean check() {
        try {
            Integer exitCodeActual = this.queryService.getMandatoryContainer(this.containerId).getExitCode();
            return exitCodeActual != null && exitCodeActual == this.exitCodeExpected;
        }
        catch (DockerAccessException e) {
            return false;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        return "on exit code " + this.exitCodeExpected;
    }
}

