/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.compose;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RestartPolicy;
import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.util.VolumeBindingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class DockerComposeServiceWrapper {
    private final Map<String, Object> configuration;
    private final String name;
    private final File composeFile;
    private final ImageConfiguration enclosingImageConfig;
    private final File baseDir;
    private boolean healthyWaitRequested;
    private boolean successExitWaitRequested;

    DockerComposeServiceWrapper(String serviceName, File composeFile, Map<String, Object> serviceDefinition, ImageConfiguration enclosingImageConfig, File baseDir) {
        this.name = serviceName;
        this.composeFile = composeFile;
        this.configuration = serviceDefinition;
        this.enclosingImageConfig = enclosingImageConfig;
        if (!baseDir.isAbsolute()) {
            throw new IllegalArgumentException("Expected the base directory '" + baseDir + "' to be an absolute path.");
        }
        this.baseDir = baseDir;
    }

    String getAlias() {
        String alias = this.asString("container_name");
        return alias != null ? alias : this.name;
    }

    String getImage() {
        return this.asString("image");
    }

    boolean requiresBuild() {
        return this.asObject("build") != null;
    }

    String getBuildDir() {
        Map buildConfig;
        Object build = this.asObject("build");
        if (build == null) {
            return null;
        }
        if (build instanceof String) {
            return (String)build;
        }
        if (!(build instanceof Map)) {
            this.throwIllegalArgumentException("build:' must be either a String or a Map");
        }
        if (!(buildConfig = (Map)build).containsKey("context")) {
            this.throwIllegalArgumentException("'build:' a context directory for a build must be specified");
        }
        return (String)buildConfig.get("context");
    }

    String getDockerfile() {
        Object build = this.asObject("build");
        if (build instanceof Map) {
            return (String)((Map)build).get("dockerfile");
        }
        return null;
    }

    Map<String, String> getBuildArgs() {
        Object build = this.asObject("build");
        if (build instanceof Map) {
            return (Map)((Map)build).get("args");
        }
        return null;
    }

    List<String> getCapAdd() {
        return this.asList("cap_add");
    }

    List<String> getCapDrop() {
        return this.asList("cap_drop");
    }

    Map<String, String> getSysctls() {
        return this.asMap("sysctls");
    }

    Arguments getCommand() {
        Object command = this.asObject("command");
        return command != null ? this.asArguments(command, "command") : null;
    }

    List<String> getDependsOn() {
        try {
            return this.asList("depends_on");
        }
        catch (ClassCastException e) {
            return new ArrayList<String>(this.asMap("depends_on").keySet());
        }
    }

    boolean usesLongSyntaxDependsOn() {
        return this.asObject("depends_on") instanceof Map;
    }

    public String getPlatform() {
        return this.asString("platform");
    }

    WaitCondition getWaitCondition(String dependentServiceName) {
        Objects.requireNonNull(dependentServiceName, "Dependent service's name may not be null");
        Object dependsOnObj = this.asObject("depends_on");
        if (dependsOnObj instanceof Map) {
            Map dependsOn = (Map)dependsOnObj;
            Object dependenSvcObj = dependsOn.get(dependentServiceName);
            if (dependenSvcObj instanceof Map) {
                Map dependency = (Map)dependenSvcObj;
                if (dependency.containsKey("condition")) {
                    String condition = (String)dependency.get("condition");
                    try {
                        return WaitCondition.fromString(condition);
                    }
                    catch (IllegalArgumentException e) {
                        this.throwIllegalArgumentException("depends_on service \"" + dependentServiceName + "\" has invalid syntax (" + e.getMessage() + ")");
                    }
                }
                this.throwIllegalArgumentException("depends_on service \"" + dependentServiceName + "\" has invalid syntax (missing condition)");
            }
            this.throwIllegalArgumentException("depends_on service \"" + dependentServiceName + "\" has invalid syntax (no map)");
        }
        this.throwIllegalArgumentException("depends_on does not use long syntax, cannot retrieve condition");
        return null;
    }

    void enableWaitCondition(WaitCondition condition) {
        Objects.requireNonNull(condition, "Condition may not be null");
        switch (condition) {
            case HEALTHY: {
                this.healthyWaitRequested = true;
                break;
            }
            case COMPLETED: {
                this.successExitWaitRequested = true;
                break;
            }
        }
    }

    WaitConfiguration getWaitConfiguration() {
        if (this.successExitWaitRequested && this.healthyWaitRequested) {
            this.throwIllegalArgumentException("Conflicting requested conditions \"service_healthy\" and \"service_completed_successfully\" for this service");
        } else {
            if (this.healthyWaitRequested) {
                return new WaitConfiguration.Builder().healthy(this.healthyWaitRequested).build();
            }
            if (this.successExitWaitRequested) {
                return new WaitConfiguration.Builder().exit(0).build();
            }
        }
        return null;
    }

    List<String> getDns() {
        return this.asList("dns");
    }

    List<String> getDnsSearch() {
        return this.asList("dns_search");
    }

    List<String> getTmpfs() {
        return this.asList("tmpfs");
    }

    Arguments getEntrypoint() {
        Object entrypoint = this.asObject("entrypoint");
        return entrypoint != null ? this.asArguments(entrypoint, "entrypoint") : null;
    }

    Map<String, String> getEnvironment() {
        return this.asMap("environment");
    }

    List<String> getExtraHosts() {
        return this.asList("extra_hosts");
    }

    Map<String, String> getLabels() {
        return this.asMap("labels");
    }

    public List<String> getLinks() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.asList("links"));
        ret.addAll(this.asList("external_links"));
        return ret;
    }

    LogConfiguration getLogConfiguration() {
        Object logConfig = this.asObject("logging");
        if (logConfig == null) {
            return null;
        }
        if (!(logConfig instanceof Map)) {
            this.throwIllegalArgumentException("'logging' has to be a map and not " + logConfig.getClass());
        }
        Map config = (Map)logConfig;
        return new LogConfiguration.Builder().logDriverName((String)config.get("driver")).logDriverOpts((Map)config.get("options")).build();
    }

    NetworkConfig getNetworkConfig() {
        String net = this.asString("network_mode");
        if (net != null) {
            return new NetworkConfig(net);
        }
        Object networks = this.asObject("networks");
        if (networks == null) {
            return null;
        }
        if (networks instanceof List) {
            List toJoin = (List)networks;
            if (toJoin.size() > 1) {
                this.throwIllegalArgumentException("'networks:' Only one custom network to join is supported currently");
            }
            return new NetworkConfig(NetworkConfig.Mode.custom, (String)toJoin.get(0));
        }
        if (networks instanceof Map) {
            Map toJoin = (Map)networks;
            if (toJoin.size() > 1) {
                this.throwIllegalArgumentException("'networks:' Only one custom network to join is supported currently");
            }
            String custom = (String)toJoin.keySet().iterator().next();
            NetworkConfig ret = new NetworkConfig(NetworkConfig.Mode.custom, custom);
            Object aliases = toJoin.get(custom);
            if (aliases != null) {
                if (aliases instanceof List) {
                    for (String alias : (List)aliases) {
                        ret.addAlias(alias);
                    }
                } else if (aliases instanceof Map) {
                    Map map = (Map)aliases;
                    if (map.containsKey("aliases")) {
                        for (String alias : (List)map.get("aliases")) {
                            ret.addAlias(alias);
                        }
                    } else {
                        this.throwIllegalArgumentException("'networks:' Aliases must be given as a map of strings. 'aliases' key not founded");
                    }
                } else {
                    this.throwIllegalArgumentException("'networks:' No aliases entry found in network config map");
                }
            }
            return ret;
        }
        this.throwIllegalArgumentException("'networks:' must beu either a list or a map");
        return null;
    }

    List<String> getPortMapping() {
        List fromYml = this.asList("ports");
        int size = fromYml.size();
        ArrayList<String> ports = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String port = (String)fromYml.get(i);
            if (port.contains(":")) {
                ports.add(port);
                continue;
            }
            ports.add(String.format("%s_port_%s:%s", this.getAlias(), i + 1, port));
        }
        return ports;
    }

    List<UlimitConfig> getUlimits() {
        Object ulimits = this.asObject("ulimits");
        if (ulimits == null) {
            return null;
        }
        if (!(ulimits instanceof Map)) {
            this.throwIllegalArgumentException("'ulimits:' must be a map");
        }
        Map ulimitMap = (Map)ulimits;
        ArrayList<UlimitConfig> ret = new ArrayList<UlimitConfig>();
        for (String ulimit : ulimitMap.keySet()) {
            Object val = ulimitMap.get(ulimit);
            if (val instanceof Map) {
                Map valMap = (Map)val;
                Integer soft = (Integer)valMap.get("soft");
                Integer hard = (Integer)valMap.get("hard");
                ret.add(new UlimitConfig(ulimit, hard, soft));
                continue;
            }
            if (val instanceof Integer) {
                ret.add(new UlimitConfig(ulimit, (Integer)val, null));
                continue;
            }
            this.throwIllegalArgumentException("'ulimits:' invalid limit value " + val + " (class : " + val.getClass() + ")");
        }
        return ret;
    }

    RunVolumeConfiguration getVolumeConfig() {
        List<String> volumesFrom;
        RunVolumeConfiguration.Builder builder = new RunVolumeConfiguration.Builder();
        List<String> volumes = this.asList("volumes");
        boolean added = false;
        if (!volumes.isEmpty()) {
            builder.bind(volumes);
            added = true;
        }
        if (!(volumesFrom = this.asList("volumes_from")).isEmpty()) {
            builder.from(volumesFrom);
            added = true;
        }
        if (added) {
            RunVolumeConfiguration runVolumeConfiguration = builder.build();
            VolumeBindingUtil.resolveRelativeVolumeBindings(this.baseDir, runVolumeConfiguration);
            return runVolumeConfiguration;
        }
        return null;
    }

    String getDomainname() {
        return this.asString("domainname");
    }

    String getHostname() {
        return this.asString("hostname");
    }

    Long getMemory() {
        return this.asLong("mem_limit");
    }

    Long getMemorySwap() {
        return this.asLong("memswap_limit");
    }

    Boolean getPrivileged() {
        return this.asBoolean("privileged");
    }

    RestartPolicy getRestartPolicy() {
        String restart = this.asString("restart");
        if (restart == null) {
            return null;
        }
        RestartPolicy.Builder builder = new RestartPolicy.Builder();
        if (restart.contains(":")) {
            String[] parts = restart.split(":", 2);
            builder.name(parts[0]).retry(Integer.valueOf(parts[1]));
        } else {
            builder.name(restart);
        }
        return builder.build();
    }

    Long getShmSize() {
        return this.asLong("shm_size");
    }

    String getUser() {
        return this.asString("user");
    }

    String getWorkingDir() {
        return this.asString("working_dir");
    }

    public String getCGroupParent() {
        return this.asString("cgroup_parent");
    }

    public String getCpuSet() {
        return this.asString("cpuset");
    }

    public String getIsolation() {
        return this.asString("isolation");
    }

    public Long getCpuShares() {
        return this.asLong("cpu_shares");
    }

    public Double getCpusCount() {
        return this.asDouble("cpus");
    }

    public List<String> getDevices() {
        return this.asList("devices");
    }

    private Object asObject(String key) {
        return this.configuration.get(key);
    }

    private String asString(String key) {
        return (String)String.class.cast(this.configuration.get(key));
    }

    private Long asLong(String key) {
        Long value = null;
        if (this.configuration.containsKey(key)) {
            value = Long.valueOf(this.configuration.get(key).toString());
        }
        return value;
    }

    private Boolean asBoolean(String key) {
        Boolean value = null;
        if (this.configuration.containsKey(key)) {
            value = Boolean.valueOf(this.configuration.get(key).toString());
        }
        return value;
    }

    private <T> List<T> asList(String key) {
        if (this.configuration.containsKey(key)) {
            List<Object> value = this.configuration.get(key);
            if (value instanceof String) {
                value = Arrays.asList(value);
            }
            return (List)List.class.cast(value);
        }
        return Collections.emptyList();
    }

    private Map<String, String> asMap(String key) {
        if (this.configuration.containsKey(key)) {
            Map<String, String> value = this.configuration.get(key);
            if (value instanceof List) {
                value = this.convertToMap((List)List.class.cast(value));
            }
            return (Map)Map.class.cast(value);
        }
        return Collections.emptyMap();
    }

    private Double asDouble(String key) {
        Double value = null;
        if (this.configuration.containsKey(key)) {
            value = Double.valueOf(this.configuration.get(key).toString());
        }
        return value;
    }

    private Arguments asArguments(Object command, String label) {
        if (command instanceof String) {
            return new Arguments((String)command);
        }
        if (command instanceof List) {
            return new Arguments((List)command);
        }
        this.throwIllegalArgumentException(String.format("'%s' must be either String or List but not %s", label, command.getClass()));
        return null;
    }

    private Map<String, String> convertToMap(List<String> list) {
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (String entry : list) {
            String[] parts = entry.split("=", 2);
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    void throwIllegalArgumentException(String msg) {
        throw new IllegalArgumentException(String.format("%s: %s - ", this.composeFile, this.name) + msg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerComposeServiceWrapper)) {
            return false;
        }
        DockerComposeServiceWrapper that = (DockerComposeServiceWrapper)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    static enum WaitCondition {
        HEALTHY("service_healthy"),
        COMPLETED("service_completed_successfully"),
        STARTED("service_started");

        private final String condition;

        private WaitCondition(String condition) {
            this.condition = condition;
        }

        static WaitCondition fromString(String string) {
            return Arrays.stream(WaitCondition.values()).filter(wc -> wc.condition.equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException("invalid condition \"" + string + "\""));
        }
    }
}

