/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.Parameter;

public class UlimitConfig
implements Serializable {
    @Parameter
    private String name;
    @Parameter
    private Integer hard;
    @Parameter
    private Integer soft;
    Pattern ULIMIT_PATTERN = Pattern.compile("^(?<name>[^=]+)=(?<hard>[^:]*):?(?<soft>[^:]*)$");

    public UlimitConfig(String name, Integer hard, Integer soft) {
        this.name = name;
        this.hard = hard;
        this.soft = soft;
    }

    public String getName() {
        return this.name;
    }

    public Integer getHard() {
        return this.hard;
    }

    public Integer getSoft() {
        return this.soft;
    }

    public UlimitConfig() {
    }

    public UlimitConfig(String ulimit) {
        Matcher matcher = this.ULIMIT_PATTERN.matcher(ulimit);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid ulimit specification " + ulimit);
        }
        this.name = matcher.group("name");
        this.hard = this.asInteger(matcher.group("hard"));
        this.soft = this.asInteger(matcher.group("soft"));
    }

    private Integer asInteger(String number) {
        if (number == null || number.length() == 0) {
            return null;
        }
        return Integer.parseInt(number);
    }

    public String serialize() {
        if (this.hard != null && this.soft != null) {
            return this.name + "=" + this.hard + ":" + this.soft;
        }
        if (this.hard != null) {
            return this.name + "=" + this.hard;
        }
        if (this.soft != null) {
            return this.name + "=:" + this.soft;
        }
        return null;
    }
}

