/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class RequestUtil {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_ALL = "*/*";

    public static HttpUriRequest newGet(String url) {
        return RequestUtil.addDefaultHeaders((HttpUriRequest)new HttpGet(url));
    }

    public static HttpUriRequest newPost(String url, String body) {
        HttpPost post = new HttpPost(url);
        if (body != null) {
            post.setEntity((HttpEntity)new StringEntity(body, Charset.defaultCharset()));
        }
        return RequestUtil.addDefaultHeaders((HttpUriRequest)post);
    }

    public static HttpUriRequest newDelete(String url) {
        return RequestUtil.addDefaultHeaders((HttpUriRequest)new HttpDelete(url));
    }

    public static HttpUriRequest addDefaultHeaders(HttpUriRequest req) {
        req.addHeader(HEADER_ACCEPT, HEADER_ACCEPT_ALL);
        req.addHeader("Content-Type", "application/json");
        return req;
    }

    public static String encode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(param);
        }
    }
}

