/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc.util;

import io.fabric8.maven.docker.access.hc.util.ClientBuilder;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class AbstractNativeClientBuilder
implements ClientBuilder {
    protected final Registry<ConnectionSocketFactory> registry;
    protected final String path;
    protected final Logger log;
    private final DnsResolver dnsResolver;
    private final int maxConnections;

    public AbstractNativeClientBuilder(String path, int maxConnections, Logger logger) {
        this.maxConnections = maxConnections;
        this.log = logger;
        this.path = path;
        this.dnsResolver = this.nullDnsResolver();
        this.registry = this.buildRegistry(path);
    }

    protected abstract ConnectionSocketFactory getConnectionSocketFactory();

    protected abstract String getProtocol();

    @Override
    public CloseableHttpClient buildPooledClient() {
        HttpClientBuilder httpBuilder = HttpClients.custom();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(this.registry, this.dnsResolver);
        manager.setDefaultMaxPerRoute(this.maxConnections);
        httpBuilder.setConnectionManager((HttpClientConnectionManager)manager);
        return httpBuilder.build();
    }

    @Override
    public CloseableHttpClient buildBasicClient() throws IOException {
        BasicHttpClientConnectionManager manager = new BasicHttpClientConnectionManager(this.registry, null, null, this.dnsResolver);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    private Registry<ConnectionSocketFactory> buildRegistry(String path) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register(this.getProtocol(), (Object)this.getConnectionSocketFactory());
        return registryBuilder.build();
    }

    private DnsResolver nullDnsResolver() {
        return new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                return new InetAddress[]{null};
            }
        };
    }
}

