/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.config.WatchMode;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="watch")
public class WatchMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.watchMode", defaultValue="both")
    private WatchMode watchMode;
    @Parameter(property="docker.watchInterval", defaultValue="5000")
    private int watchInterval;
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.watchPostGoal")
    private String watchPostGoal;
    @Parameter(property="docker.watchPostExec")
    private String watchPostExec;
    @Parameter(property="docker.containerNamePattern")
    private String containerNamePattern = "%n-%i";
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;

    @Override
    protected synchronized void executeInternal(ServiceHub hub) throws IOException, MojoExecutionException {
        BuildService.BuildContext buildContext = this.getBuildContext();
        WatchService.WatchContext watchContext = this.getWatchContext(hub);
        hub.getWatchService().watch(watchContext, buildContext, this.getResolvedImages());
    }

    protected WatchService.WatchContext getWatchContext(ServiceHub hub) throws IOException {
        return new WatchService.WatchContext.Builder().watchInterval(this.watchInterval).watchMode(this.watchMode).watchPostGoal(this.watchPostGoal).watchPostExec(this.watchPostExec).autoCreateCustomNetworks(this.autoCreateCustomNetworks).keepContainer(this.keepContainer).keepRunning(this.keepRunning).removeVolumes(this.removeVolumes).containerNamePattern(this.containerNamePattern).buildTimestamp(this.getBuildTimestamp()).pomLabel(this.getGavLabel()).mojoParameters(this.createMojoParameters()).follow(this.follow()).showLogs(this.showLogs()).serviceHubFactory(this.serviceHubFactory).hub(hub).dispatcher(this.getLogDispatcher(hub)).build();
    }

    private String showLogs() {
        return System.getProperty("docker.showLogs");
    }

    private boolean follow() {
        return Boolean.valueOf(System.getProperty("docker.follow", "false"));
    }
}

