/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.maven.plugin;

import io.fabric8.crd.generator.collector.CustomResourceCollector;
import io.fabric8.crd.generator.maven.plugin.ClasspathType;
import io.fabric8.crd.generator.maven.plugin.Dependency;
import io.fabric8.crd.generator.maven.plugin.FilterSet;
import io.fabric8.crdv2.generator.CRDGenerationInfo;
import io.fabric8.crdv2.generator.CRDGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class CrdGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject mavenProject;
    @Parameter(property="fabric8.crd-generator.classesToScan", defaultValue="${project.build.outputDirectory}", readonly=true)
    File classesToScan;
    @Parameter(property="fabric8.crd-generator.customResourceClasses")
    List<String> customResourceClasses = new LinkedList<String>();
    @Parameter(property="fabric8.crd-generator.dependenciesToScan")
    List<Dependency> dependenciesToScan = new LinkedList<Dependency>();
    @Parameter(property="fabric8.crd-generator.inclusions")
    FilterSet inclusions = new FilterSet();
    @Parameter(property="fabric8.crd-generator.exclusions")
    FilterSet exclusions = new FilterSet();
    @Parameter(property="fabric8.crd-generator.classpath", defaultValue="WITH_RUNTIME_DEPENDENCIES")
    ClasspathType classpath;
    @Parameter(property="fabric8.crd-generator.outputDirectory", defaultValue="${project.build.outputDirectory}/META-INF/fabric8/")
    File outputDirectory;
    @Parameter(property="fabric8.crd-generator.forceIndex", defaultValue="false")
    boolean forceIndex;
    @Parameter(property="fabric8.crd-generator.forceScan", defaultValue="false")
    boolean forceScan;
    @Parameter(property="fabric8.crd-generator.parallel", defaultValue="true")
    boolean parallel;
    @Parameter(property="fabric8.crd-generator.implicitPreserveUnknownFields", defaultValue="false")
    boolean implicitPreserveUnknownFields;
    @Parameter(property="fabric8.crd-generator.skip", defaultValue="false")
    boolean skip;
    private final CustomResourceCollector customResourceCollector;
    private final CRDGenerator crdGenerator;

    public CrdGeneratorMojo() {
        this(null, null);
    }

    CrdGeneratorMojo(CustomResourceCollector customResourceCollector, CRDGenerator crdGenerator) {
        this.customResourceCollector = Optional.ofNullable(customResourceCollector).orElseGet(CustomResourceCollector::new);
        this.crdGenerator = Optional.ofNullable(crdGenerator).orElseGet(CRDGenerator::new);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"CRD-Generator execution skipped");
            return;
        }
        LinkedList<File> filesToScan = new LinkedList<File>();
        if (this.classesToScan.exists()) {
            filesToScan.add(this.classesToScan);
        }
        filesToScan.addAll(this.getDependencyArchives());
        this.customResourceCollector.withParentClassLoader(Thread.currentThread().getContextClassLoader()).withClasspathElements(this.classpath.getClasspathElements(this.mavenProject)).withFilesToScan(filesToScan).withForceIndex(this.forceIndex).withForceScan(this.forceScan).withIncludePackages(this.inclusions.getPackages()).withExcludePackages(this.exclusions.getPackages()).withCustomResourceClasses(this.customResourceClasses);
        List customResourceClassesLoaded = this.customResourceCollector.findCustomResourceClasses();
        try {
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create output directory: " + e.getMessage());
        }
        this.crdGenerator.customResourceClasses((Collection)customResourceClassesLoaded).withParallelGenerationEnabled(this.parallel).withImplicitPreserveUnknownFields(this.implicitPreserveUnknownFields).inOutputDir(this.outputDirectory);
        CRDGenerationInfo crdGenerationInfo = this.crdGenerator.detailedGenerate();
        crdGenerationInfo.getCRDDetailsPerNameAndVersion().forEach((crdName, versionToInfo) -> {
            this.getLog().info((CharSequence)("Generated CRD " + crdName + ":"));
            versionToInfo.forEach((version, info) -> this.getLog().info((CharSequence)(" " + version + " -> " + info.getFilePath())));
        });
    }

    private List<File> getDependencyArchives() {
        return this.dependenciesToScan.stream().map(this::getDependencyArchive).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    private Optional<File> getDependencyArchive(Dependency dependency) {
        for (Artifact artifact : this.mavenProject.getArtifacts()) {
            if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId()) || dependency.getClassifier() != null && !artifact.getClassifier().equals(dependency.getClassifier())) continue;
            File jarFile = artifact.getFile();
            if (jarFile == null) {
                this.getLog().warn((CharSequence)("Skip scanning dependency, artifact file does not exist for dependency: " + dependency));
                return Optional.empty();
            }
            return Optional.of(jarFile);
        }
        this.getLog().warn((CharSequence)("Skip scanning dependency, artifact for dependency not found: " + dependency));
        return Optional.empty();
    }
}

