/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import java.time.Duration;
import java.util.Objects;

public class LeaderElectionConfigFluent<A extends LeaderElectionConfigFluent<A>>
extends BaseFluent<A> {
    private LeaderCallbacks leaderCallbacks;
    private Duration leaseDuration;
    private Lock lock;
    private String name;
    private boolean releaseOnCancel;
    private Duration renewDeadline;
    private Duration retryPeriod;

    public LeaderElectionConfigFluent() {
    }

    public LeaderElectionConfigFluent(LeaderElectionConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LeaderElectionConfig instance) {
        if (instance != null) {
            this.withLock(instance.getLock());
            this.withLeaseDuration(instance.getLeaseDuration());
            this.withRenewDeadline(instance.getRenewDeadline());
            this.withRetryPeriod(instance.getRetryPeriod());
            this.withLeaderCallbacks(instance.getLeaderCallbacks());
            this.withReleaseOnCancel(instance.isReleaseOnCancel());
            this.withName(instance.getName());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaderElectionConfigFluent that = (LeaderElectionConfigFluent)o;
        if (!Objects.equals(this.lock, that.lock)) {
            return false;
        }
        if (!Objects.equals(this.leaseDuration, that.leaseDuration)) {
            return false;
        }
        if (!Objects.equals(this.renewDeadline, that.renewDeadline)) {
            return false;
        }
        if (!Objects.equals(this.retryPeriod, that.retryPeriod)) {
            return false;
        }
        if (!Objects.equals(this.leaderCallbacks, that.leaderCallbacks)) {
            return false;
        }
        if (this.releaseOnCancel != that.releaseOnCancel) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public LeaderCallbacks getLeaderCallbacks() {
        return this.leaderCallbacks;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public Lock getLock() {
        return this.lock;
    }

    public String getName() {
        return this.name;
    }

    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public boolean hasLeaderCallbacks() {
        return this.leaderCallbacks != null;
    }

    public boolean hasLeaseDuration() {
        return this.leaseDuration != null;
    }

    public boolean hasLock() {
        return this.lock != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasReleaseOnCancel() {
        return true;
    }

    public boolean hasRenewDeadline() {
        return this.renewDeadline != null;
    }

    public boolean hasRetryPeriod() {
        return this.retryPeriod != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lock, this.leaseDuration, this.renewDeadline, this.retryPeriod, this.leaderCallbacks, this.releaseOnCancel, this.name);
    }

    public boolean isReleaseOnCancel() {
        return this.releaseOnCancel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lock != null) {
            sb.append("lock:");
            sb.append(this.lock);
            sb.append(",");
        }
        if (this.leaseDuration != null) {
            sb.append("leaseDuration:");
            sb.append(this.leaseDuration);
            sb.append(",");
        }
        if (this.renewDeadline != null) {
            sb.append("renewDeadline:");
            sb.append(this.renewDeadline);
            sb.append(",");
        }
        if (this.retryPeriod != null) {
            sb.append("retryPeriod:");
            sb.append(this.retryPeriod);
            sb.append(",");
        }
        if (this.leaderCallbacks != null) {
            sb.append("leaderCallbacks:");
            sb.append(this.leaderCallbacks);
            sb.append(",");
        }
        sb.append("releaseOnCancel:");
        sb.append(this.releaseOnCancel);
        sb.append(",");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withLeaderCallbacks(LeaderCallbacks leaderCallbacks) {
        this.leaderCallbacks = leaderCallbacks;
        return (A)this;
    }

    public A withLeaseDuration(Duration leaseDuration) {
        this.leaseDuration = leaseDuration;
        return (A)this;
    }

    public A withLock(Lock lock) {
        this.lock = lock;
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public A withReleaseOnCancel() {
        return this.withReleaseOnCancel(true);
    }

    public A withReleaseOnCancel(boolean releaseOnCancel) {
        this.releaseOnCancel = releaseOnCancel;
        return (A)this;
    }

    public A withRenewDeadline(Duration renewDeadline) {
        this.renewDeadline = renewDeadline;
        return (A)this;
    }

    public A withRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
        return (A)this;
    }
}

