/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.client.CustomResource;
import java.util.Objects;
import java.util.Optional;

public class CustomResourceFluent<S, T, A extends CustomResourceFluent<S, T, A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private S spec;
    private T status;

    public CustomResourceFluent() {
    }

    public CustomResourceFluent(CustomResource<S, T> instance) {
        this.copyInstance(instance);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(CustomResource<S, T> instance) {
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withKind(instance.getKind());
            this.withApiVersion(instance.getApiVersion());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceFluent that = (CustomResourceFluent)o;
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.apiVersion, that.apiVersion);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public S getSpec() {
        return this.spec;
    }

    public T getStatus() {
        return this.status;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.metadata, this.spec, this.status, this.kind, this.apiVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec);
            sb.append(",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public A withSpec(S spec) {
        this.spec = spec;
        return (A)this;
    }

    public A withStatus(T status) {
        this.status = status;
        return (A)this;
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomResourceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

