/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.RouteGroupKind;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.RouteGroupKindBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.RouteGroupKindFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ListenerStatusFluent<A extends ListenerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer attachedRoutes;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String name;
    private ArrayList<RouteGroupKindBuilder> supportedKinds = new ArrayList();

    public ListenerStatusFluent() {
    }

    public ListenerStatusFluent(ListenerStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToSupportedKinds(Collection<RouteGroupKind> items) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        }
        return (A)this;
    }

    public SupportedKindsNested<A> addNewSupportedKind() {
        return new SupportedKindsNested(-1, null);
    }

    public A addNewSupportedKind(String group, String kind) {
        return this.addToSupportedKinds(new RouteGroupKind(group, kind));
    }

    public SupportedKindsNested<A> addNewSupportedKindLike(RouteGroupKind item) {
        return new SupportedKindsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A addToSupportedKinds(RouteGroupKind ... items) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        }
        return (A)this;
    }

    public A addToSupportedKinds(int index, RouteGroupKind item) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this.supportedKinds.size()) {
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        } else {
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(index, builder);
        }
        return (A)this;
    }

    public RouteGroupKind buildFirstSupportedKind() {
        return this.supportedKinds.get(0).build();
    }

    public RouteGroupKind buildLastSupportedKind() {
        return this.supportedKinds.get(this.supportedKinds.size() - 1).build();
    }

    public RouteGroupKind buildMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.supportedKinds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public RouteGroupKind buildSupportedKind(int index) {
        return this.supportedKinds.get(index).build();
    }

    public List<RouteGroupKind> buildSupportedKinds() {
        return this.supportedKinds != null ? ListenerStatusFluent.build(this.supportedKinds) : null;
    }

    protected void copyInstance(ListenerStatus instance) {
        ListenerStatus listenerStatus = instance = instance != null ? instance : new ListenerStatus();
        if (instance != null) {
            this.withAttachedRoutes(instance.getAttachedRoutes());
            this.withConditions(instance.getConditions());
            this.withName(instance.getName());
            this.withSupportedKinds(instance.getSupportedKinds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SupportedKindsNested<A> editFirstSupportedKind() {
        if (this.supportedKinds.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "supportedKinds"));
        }
        return this.setNewSupportedKindLike(0, this.buildSupportedKind(0));
    }

    public SupportedKindsNested<A> editLastSupportedKind() {
        int index = this.supportedKinds.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "supportedKinds"));
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    public SupportedKindsNested<A> editMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.supportedKinds.size(); ++i) {
            if (!predicate.test(this.supportedKinds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "supportedKinds"));
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    public SupportedKindsNested<A> editSupportedKind(int index) {
        if (this.supportedKinds.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "supportedKinds"));
        }
        return this.setNewSupportedKindLike(index, this.buildSupportedKind(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListenerStatusFluent that = (ListenerStatusFluent)o;
        if (!Objects.equals(this.attachedRoutes, that.attachedRoutes)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.supportedKinds, that.supportedKinds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getAttachedRoutes() {
        return this.attachedRoutes;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAttachedRoutes() {
        return this.attachedRoutes != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
        for (RouteGroupKindBuilder item : this.supportedKinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasSupportedKinds() {
        return this.supportedKinds != null && !this.supportedKinds.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachedRoutes, this.conditions, this.name, this.supportedKinds, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSupportedKinds(Collection<RouteGroupKind> items) {
        if (this.supportedKinds == null) {
            return (A)this;
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").remove(builder);
            this.supportedKinds.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeFromSupportedKinds(RouteGroupKind ... items) {
        if (this.supportedKinds == null) {
            return (A)this;
        }
        for (RouteGroupKind item : items) {
            RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
            this._visitables.get("supportedKinds").remove(builder);
            this.supportedKinds.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSupportedKinds(Predicate<RouteGroupKindBuilder> predicate) {
        if (this.supportedKinds == null) {
            return (A)this;
        }
        Iterator<RouteGroupKindBuilder> each = this.supportedKinds.iterator();
        Object visitables = this._visitables.get("supportedKinds");
        while (each.hasNext()) {
            RouteGroupKindBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public SupportedKindsNested<A> setNewSupportedKindLike(int index, RouteGroupKind item) {
        return new SupportedKindsNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A setToSupportedKinds(int index, RouteGroupKind item) {
        if (this.supportedKinds == null) {
            this.supportedKinds = new ArrayList();
        }
        RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
        if (index < 0 || index >= this.supportedKinds.size()) {
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.add(builder);
        } else {
            this._visitables.get("supportedKinds").add(builder);
            this.supportedKinds.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachedRoutes != null) {
            sb.append("attachedRoutes:");
            sb.append(this.attachedRoutes);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.supportedKinds != null && !this.supportedKinds.isEmpty()) {
            sb.append("supportedKinds:");
            sb.append(this.supportedKinds);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAttachedRoutes(Integer attachedRoutes) {
        this.attachedRoutes = attachedRoutes;
        return (A)this;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public A withSupportedKinds(List<RouteGroupKind> supportedKinds) {
        if (this.supportedKinds != null) {
            this._visitables.get("supportedKinds").clear();
        }
        if (supportedKinds != null) {
            this.supportedKinds = new ArrayList();
            for (RouteGroupKind item : supportedKinds) {
                this.addToSupportedKinds(item);
            }
        } else {
            this.supportedKinds = null;
        }
        return (A)this;
    }

    public A withSupportedKinds(RouteGroupKind ... supportedKinds) {
        if (this.supportedKinds != null) {
            this.supportedKinds.clear();
            this._visitables.remove("supportedKinds");
        }
        if (supportedKinds != null) {
            for (RouteGroupKind item : supportedKinds) {
                this.addToSupportedKinds(item);
            }
        }
        return (A)this;
    }

    public class SupportedKindsNested<N>
    extends RouteGroupKindFluent<SupportedKindsNested<N>>
    implements Nested<N> {
        RouteGroupKindBuilder builder;
        int index;

        SupportedKindsNested(int index, RouteGroupKind item) {
            this.index = index;
            this.builder = new RouteGroupKindBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ListenerStatusFluent.this.setToSupportedKinds(this.index, this.builder.build());
        }

        public N endSupportedKind() {
            return this.and();
        }
    }
}

