/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FrontendTLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FrontendTLSConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.FrontendTLSConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLS;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLSBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayBackendTLSFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayTLSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GatewayTLSConfigFluent<A extends GatewayTLSConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private GatewayBackendTLSBuilder backend;
    private FrontendTLSConfigBuilder frontend;

    public GatewayTLSConfigFluent() {
    }

    public GatewayTLSConfigFluent(GatewayTLSConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public GatewayBackendTLS buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    public FrontendTLSConfig buildFrontend() {
        return this.frontend != null ? this.frontend.build() : null;
    }

    protected void copyInstance(GatewayTLSConfig instance) {
        GatewayTLSConfig gatewayTLSConfig = instance = instance != null ? instance : new GatewayTLSConfig();
        if (instance != null) {
            this.withBackend(instance.getBackend());
            this.withFrontend(instance.getFrontend());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BackendNested<A> editBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(null));
    }

    public FrontendNested<A> editFrontend() {
        return this.withNewFrontendLike(Optional.ofNullable(this.buildFrontend()).orElse(null));
    }

    public BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(new GatewayBackendTLSBuilder().build()));
    }

    public BackendNested<A> editOrNewBackendLike(GatewayBackendTLS item) {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(item));
    }

    public FrontendNested<A> editOrNewFrontend() {
        return this.withNewFrontendLike(Optional.ofNullable(this.buildFrontend()).orElse(new FrontendTLSConfigBuilder().build()));
    }

    public FrontendNested<A> editOrNewFrontendLike(FrontendTLSConfig item) {
        return this.withNewFrontendLike(Optional.ofNullable(this.buildFrontend()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayTLSConfigFluent that = (GatewayTLSConfigFluent)o;
        if (!Objects.equals(this.backend, that.backend)) {
            return false;
        }
        if (!Objects.equals(this.frontend, that.frontend)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public boolean hasFrontend() {
        return this.frontend != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backend, this.frontend, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backend != null) {
            sb.append("backend:");
            sb.append(this.backend);
            sb.append(",");
        }
        if (this.frontend != null) {
            sb.append("frontend:");
            sb.append(this.frontend);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withBackend(GatewayBackendTLS backend) {
        this._visitables.remove("backend");
        if (backend != null) {
            this.backend = new GatewayBackendTLSBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        } else {
            this.backend = null;
            this._visitables.get("backend").remove(this.backend);
        }
        return (A)this;
    }

    public A withFrontend(FrontendTLSConfig frontend) {
        this._visitables.remove("frontend");
        if (frontend != null) {
            this.frontend = new FrontendTLSConfigBuilder(frontend);
            this._visitables.get("frontend").add(this.frontend);
        } else {
            this.frontend = null;
            this._visitables.get("frontend").remove(this.frontend);
        }
        return (A)this;
    }

    public BackendNested<A> withNewBackend() {
        return new BackendNested(null);
    }

    public BackendNested<A> withNewBackendLike(GatewayBackendTLS item) {
        return new BackendNested(item);
    }

    public FrontendNested<A> withNewFrontend() {
        return new FrontendNested(null);
    }

    public FrontendNested<A> withNewFrontendLike(FrontendTLSConfig item) {
        return new FrontendNested(item);
    }

    public class FrontendNested<N>
    extends FrontendTLSConfigFluent<FrontendNested<N>>
    implements Nested<N> {
        FrontendTLSConfigBuilder builder;

        FrontendNested(FrontendTLSConfig item) {
            this.builder = new FrontendTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewayTLSConfigFluent.this.withFrontend(this.builder.build());
        }

        public N endFrontend() {
            return this.and();
        }
    }

    public class BackendNested<N>
    extends GatewayBackendTLSFluent<BackendNested<N>>
    implements Nested<N> {
        GatewayBackendTLSBuilder builder;

        BackendNested(GatewayBackendTLS item) {
            this.builder = new GatewayBackendTLSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewayTLSConfigFluent.this.withBackend(this.builder.build());
        }

        public N endBackend() {
            return this.and();
        }
    }
}

