/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointHints;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZone;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZoneBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZoneFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointHintsFluent<A extends EndpointHintsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ForZoneBuilder> forZones = new ArrayList();

    public EndpointHintsFluent() {
    }

    public EndpointHintsFluent(EndpointHints instance) {
        this.copyInstance(instance);
    }

    public A addAllToForZones(Collection<ForZone> items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public ForZonesNested<A> addNewForZone() {
        return new ForZonesNested(-1, null);
    }

    public A addNewForZone(String name) {
        return this.addToForZones(new ForZone(name));
    }

    public ForZonesNested<A> addNewForZoneLike(ForZone item) {
        return new ForZonesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToForZones(ForZone ... items) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        }
        return (A)this;
    }

    public A addToForZones(int index, ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        ForZoneBuilder builder = new ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(index, builder);
        }
        return (A)this;
    }

    public ForZone buildFirstForZone() {
        return this.forZones.get(0).build();
    }

    public ForZone buildForZone(int index) {
        return this.forZones.get(index).build();
    }

    public List<ForZone> buildForZones() {
        return this.forZones != null ? EndpointHintsFluent.build(this.forZones) : null;
    }

    public ForZone buildLastForZone() {
        return this.forZones.get(this.forZones.size() - 1).build();
    }

    public ForZone buildMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        for (ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(EndpointHints instance) {
        EndpointHints endpointHints = instance = instance != null ? instance : new EndpointHints();
        if (instance != null) {
            this.withForZones(instance.getForZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ForZonesNested<A> editFirstForZone() {
        if (this.forZones.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "forZones"));
        }
        return this.setNewForZoneLike(0, this.buildForZone(0));
    }

    public ForZonesNested<A> editForZone(int index) {
        if (this.forZones.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "forZones"));
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editLastForZone() {
        int index = this.forZones.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "forZones"));
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    public ForZonesNested<A> editMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.forZones.size(); ++i) {
            if (!predicate.test(this.forZones.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "forZones"));
        }
        return this.setNewForZoneLike(index, this.buildForZone(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointHintsFluent that = (EndpointHintsFluent)o;
        if (!Objects.equals(this.forZones, that.forZones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasForZones() {
        return this.forZones != null && !this.forZones.isEmpty();
    }

    public boolean hasMatchingForZone(Predicate<ForZoneBuilder> predicate) {
        for (ForZoneBuilder item : this.forZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.forZones, this.additionalProperties);
    }

    public A removeAllFromForZones(Collection<ForZone> items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromForZones(ForZone ... items) {
        if (this.forZones == null) {
            return (A)this;
        }
        for (ForZone item : items) {
            ForZoneBuilder builder = new ForZoneBuilder(item);
            this._visitables.get("forZones").remove(builder);
            this.forZones.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromForZones(Predicate<ForZoneBuilder> predicate) {
        if (this.forZones == null) {
            return (A)this;
        }
        Iterator<ForZoneBuilder> each = this.forZones.iterator();
        Object visitables = this._visitables.get("forZones");
        while (each.hasNext()) {
            ForZoneBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public ForZonesNested<A> setNewForZoneLike(int index, ForZone item) {
        return new ForZonesNested(index, item);
    }

    public A setToForZones(int index, ForZone item) {
        if (this.forZones == null) {
            this.forZones = new ArrayList();
        }
        ForZoneBuilder builder = new ForZoneBuilder(item);
        if (index < 0 || index >= this.forZones.size()) {
            this._visitables.get("forZones").add(builder);
            this.forZones.add(builder);
        } else {
            this._visitables.get("forZones").add(builder);
            this.forZones.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.forZones != null && !this.forZones.isEmpty()) {
            sb.append("forZones:");
            sb.append(this.forZones);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withForZones(List<ForZone> forZones) {
        if (this.forZones != null) {
            this._visitables.get("forZones").clear();
        }
        if (forZones != null) {
            this.forZones = new ArrayList();
            for (ForZone item : forZones) {
                this.addToForZones(item);
            }
        } else {
            this.forZones = null;
        }
        return (A)this;
    }

    public A withForZones(ForZone ... forZones) {
        if (this.forZones != null) {
            this.forZones.clear();
            this._visitables.remove("forZones");
        }
        if (forZones != null) {
            for (ForZone item : forZones) {
                this.addToForZones(item);
            }
        }
        return (A)this;
    }

    public class ForZonesNested<N>
    extends ForZoneFluent<ForZonesNested<N>>
    implements Nested<N> {
        ForZoneBuilder builder;
        int index;

        ForZonesNested(int index, ForZone item) {
            this.index = index;
            this.builder = new ForZoneBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointHintsFluent.this.setToForZones(this.index, this.builder.build());
        }

        public N endForZone() {
            return this.and();
        }
    }
}

