/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ServicePortFluent<A extends ServicePortFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String appProtocol;
    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private IntOrStringBuilder targetPort;

    public ServicePortFluent() {
    }

    public ServicePortFluent(ServicePort instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public IntOrString buildTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    protected void copyInstance(ServicePort instance) {
        ServicePort servicePort = instance = instance != null ? instance : new ServicePort();
        if (instance != null) {
            this.withAppProtocol(instance.getAppProtocol());
            this.withName(instance.getName());
            this.withNodePort(instance.getNodePort());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withTargetPort(instance.getTargetPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TargetPortNested<A> editOrNewTargetPort() {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(new IntOrStringBuilder().build()));
    }

    public TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(item));
    }

    public TargetPortNested<A> editTargetPort() {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(null));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePortFluent that = (ServicePortFluent)o;
        if (!Objects.equals(this.appProtocol, that.appProtocol)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        if (!Objects.equals(this.targetPort, that.targetPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAppProtocol() {
        return this.appProtocol;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public boolean hasTargetPort() {
        return this.targetPort != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appProtocol != null) {
            sb.append("appProtocol:");
            sb.append(this.appProtocol);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol);
            sb.append(",");
        }
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return (A)this;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNested(null);
    }

    public A withNewTargetPort(Object value) {
        return this.withTargetPort(new IntOrString(value));
    }

    public TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNested(item);
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    public A withTargetPort(IntOrString targetPort) {
        this._visitables.remove("targetPort");
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.get("targetPort").add(this.targetPort);
        } else {
            this.targetPort = null;
            this._visitables.get("targetPort").remove(this.targetPort);
        }
        return (A)this;
    }

    public class TargetPortNested<N>
    extends IntOrStringFluent<TargetPortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        TargetPortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServicePortFluent.this.withTargetPort(this.builder.build());
        }

        public N endTargetPort() {
            return this.and();
        }
    }
}

