/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceRequest;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceSelectorBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceSelectorFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceRequestFluent<A extends DeviceRequestFluent<A>>
extends BaseFluent<A> {
    private Boolean adminAccess;
    private String allocationMode;
    private Long count;
    private String deviceClassName;
    private String name;
    private ArrayList<DeviceSelectorBuilder> selectors = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DeviceRequestFluent() {
    }

    public DeviceRequestFluent(DeviceRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceRequest instance) {
        DeviceRequest deviceRequest = instance = instance != null ? instance : new DeviceRequest();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withAllocationMode(instance.getAllocationMode());
            this.withCount(instance.getCount());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withName(instance.getName());
            this.withSelectors(instance.getSelectors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)this;
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public String getAllocationMode() {
        return this.allocationMode;
    }

    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    public boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    public Long getCount() {
        return this.count;
    }

    public A withCount(Long count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)this;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(index, builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").set(index, builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceSelector> buildSelectors() {
        return this.selectors != null ? DeviceRequestFluent.build(this.selectors) : null;
    }

    public DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public DeviceSelector buildMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException("Can't edit selectors. Index exceeds size.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException("Can't edit first selectors. The list is empty.");
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last selectors. The list is empty.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching selectors. No match found.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceRequestFluent that = (DeviceRequestFluent)o;
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.selectors, that.selectors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.count, this.deviceClassName, this.name, this.selectors, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess + ",");
        }
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public class SelectorsNested<N>
    extends DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, DeviceSelector item) {
            this.index = index;
            this.builder = new DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceRequestFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

