/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.cli;

import io.fabric8.crd.generator.cli.SourceParameter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import picocli.CommandLine;

class SourceParameterTypeConverter
implements CommandLine.ITypeConverter<SourceParameter> {
    private static final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern FQCN_PATTERN = Pattern.compile("(" + VALID_JAVA_IDENTIFIER + "\\.)*+" + VALID_JAVA_IDENTIFIER);

    SourceParameterTypeConverter() {
    }

    static boolean isFQCN(String value) {
        return FQCN_PATTERN.matcher(value).matches();
    }

    @Override
    public SourceParameter convert(String value) throws IOException {
        File f = new File(value);
        if (f.exists()) {
            return new SourceParameter.FileToScan(f.getCanonicalFile());
        }
        if (SourceParameterTypeConverter.isFQCN(value)) {
            return new SourceParameter.CustomResourceClass(value);
        }
        throw new IllegalArgumentException("Not an existing file or a full qualified class name.");
    }
}

