/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.apt;

import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.utils.Pluralize;
import io.fabric8.kubernetes.model.Scope;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.ShortNames;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.model.annotation.Version"})
public class CustomResourceAnnotationProcessor
extends AbstractProcessor {
    final CRDGenerator generator = new CRDGenerator();
    private static final String CUSTOM_RESOURCE_NAME = CustomResource.class.getCanonicalName();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generator.withOutput((CRDGenerator.CRDOutput)new FileObjectCRDOutput()).generate();
            return true;
        }
        CodegenContext.create((Elements)this.processingEnv.getElementUtils(), (Types)this.processingEnv.getTypeUtils());
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                this.generator.customResources(new CustomResourceInfo[]{this.toCustomResourceInfo((TypeElement)element)});
            }
        }
        return false;
    }

    private CustomResourceInfo toCustomResourceInfo(TypeElement customResource) {
        List<? extends TypeMirror> typeArguments;
        Name crClassName = customResource.getQualifiedName();
        String specClassName = null;
        String statusClassName = null;
        ClassRef statusType = null;
        boolean unreliable = true;
        DeclaredType superclass = (DeclaredType)customResource.getSuperclass();
        if (CUSTOM_RESOURCE_NAME.equals(superclass.asElement().toString()) && (typeArguments = superclass.getTypeArguments()).size() == 2) {
            specClassName = ((TypeElement)((DeclaredType)typeArguments.get(0)).asElement()).getQualifiedName().toString();
            TypeElement status = (TypeElement)((DeclaredType)typeArguments.get(1)).asElement();
            statusClassName = status.getQualifiedName().toString();
            if (!statusClassName.equals(Void.class.getCanonicalName())) {
                statusType = ((TypeDef)ElementTo.TYPEDEF.apply((Object)status)).toReference(new TypeRef[0]);
            }
            unreliable = false;
        }
        if (unreliable) {
            System.out.println("Cannot reliably determine spec and status types for  " + crClassName + " because it isn't parameterized with only spec and status types. Status replicas detection will be deactivated.");
        }
        String group = customResource.getAnnotation(Group.class).value();
        String version = customResource.getAnnotation(Version.class).value();
        String kind = Optional.ofNullable(customResource.getAnnotation(Kind.class)).map(Kind::value).orElse(customResource.getSimpleName().toString());
        String singular = Optional.ofNullable(customResource.getAnnotation(Singular.class)).map(Singular::value).orElse(kind.toLowerCase(Locale.ROOT));
        String plural = Optional.ofNullable(customResource.getAnnotation(Plural.class)).map(Plural::value).map(s -> s.toLowerCase(Locale.ROOT)).orElse(Pluralize.toPlural((String)singular));
        String[] shortNames = Optional.ofNullable(customResource.getAnnotation(ShortNames.class)).map(ShortNames::value).orElse(new String[0]);
        boolean storage = customResource.getAnnotation(Version.class).storage();
        boolean served = customResource.getAnnotation(Version.class).served();
        Scope scope = customResource.getInterfaces().stream().filter(t -> t.toString().equals(Namespaced.class.getTypeName())).map(t -> Scope.NAMESPACED).findFirst().orElse(Scope.CLUSTER);
        TypeDef definition = (TypeDef)ElementTo.TYPEDEF.apply((Object)customResource);
        return new CustomResourceInfo(group, version, kind, singular, plural, shortNames, storage, served, scope, (TypeRef)statusType, definition, crClassName.toString(), specClassName, statusClassName);
    }

    private class FileObjectCRDOutput
    implements CRDGenerator.CRDOutput {
        private FileObject yml;
        private OutputStream out;

        private FileObjectCRDOutput() {
        }

        public OutputStream outputFor(String crdFileName) throws IOException {
            this.yml = CustomResourceAnnotationProcessor.this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/fabric8/" + crdFileName, new Element[0]);
            this.out = this.yml.openOutputStream();
            return this.out;
        }

        public URI crdURI() {
            return this.yml.toUri();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

