/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.sundr.model.ClassRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class InternalSchemaSwaps {
    private final Map<Key, Value> swaps = new HashMap<Key, Value>();

    public void registerSwap(ClassRef definitionType, ClassRef originalType, String fieldName, ClassRef targetType) {
        Value value = new Value(definitionType, originalType, fieldName, targetType);
        this.swaps.put(new Key(originalType, fieldName), value);
    }

    public Optional<ClassRef> lookupAndMark(ClassRef originalType, String name) {
        Value value = this.swaps.get(new Key(originalType, name));
        if (value != null) {
            value.markUsed();
            return Optional.of(value.getTargetType());
        }
        return Optional.empty();
    }

    public void throwIfUnmatchedSwaps() {
        String unmatchedSchemaSwaps = this.swaps.values().stream().filter(value -> !((Value)value).used).map(Object::toString).collect(Collectors.joining(", "));
        if (!unmatchedSchemaSwaps.isEmpty()) {
            throw new IllegalArgumentException("Unmatched SchemaSwaps: " + unmatchedSchemaSwaps);
        }
    }

    private static class Value {
        private final ClassRef originalType;
        private final String fieldName;
        private final ClassRef targetType;
        private boolean used;
        private final ClassRef definitionType;

        public Value(ClassRef definitionType, ClassRef originalType, String fieldName, ClassRef targetType) {
            this.definitionType = definitionType;
            this.originalType = originalType;
            this.fieldName = fieldName;
            this.targetType = targetType;
            this.used = false;
        }

        private void markUsed() {
            this.used = true;
        }

        public ClassRef getOriginalType() {
            return this.originalType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ClassRef getTargetType() {
            return this.targetType;
        }

        public boolean isUsed() {
            return this.used;
        }

        public String toString() {
            return "@SchemaSwap(originalType=" + this.originalType + ", fieldName=\"" + this.fieldName + "\", targetType=" + this.targetType + ") on " + this.definitionType;
        }
    }

    private static final class Key {
        private final ClassRef originalType;
        private final String fieldName;

        public Key(ClassRef originalType, String fieldName) {
            this.originalType = originalType;
            this.fieldName = fieldName;
        }

        public ClassRef getOriginalType() {
            return this.originalType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.originalType, key.originalType) && Objects.equals(this.fieldName, key.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.originalType, this.fieldName);
        }

        public String toString() {
            return new StringJoiner(", ", Key.class.getSimpleName() + "[", "]").add("originalType=" + this.originalType).add("fieldName='" + this.fieldName + "'").toString();
        }
    }
}

