/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.crd.generator.Resources;
import io.fabric8.crd.generator.v1beta1.CustomResourceHandler;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public class CRDGenerator {
    private final Resources resources = new Resources();
    private final io.fabric8.crd.generator.v1.CustomResourceHandler v1Handler = new io.fabric8.crd.generator.v1.CustomResourceHandler(this.resources);
    private final CustomResourceHandler v1beta1Handler = new CustomResourceHandler(this.resources);
    private CRDOutput output;
    private boolean hasResources;
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));

    public CRDGenerator inOutputDir(File outputDir) {
        this.output = new DirCRDOutput(outputDir);
        return this;
    }

    public CRDGenerator withOutput(CRDOutput output) {
        this.output = output;
        return this;
    }

    public CRDGenerator customResources(CustomResourceInfo ... infos) {
        for (CustomResourceInfo info : infos) {
            if (info == null) continue;
            this.hasResources = true;
            System.out.println("Generating '" + info.crdName() + "' version '" + info.version() + "' with " + info.crClassName() + " (spec: " + info.specClassName().orElse("undetermined") + " / status: " + info.statusClassName().orElse("undetermined") + ")");
            this.v1Handler.handle(info);
            this.v1beta1Handler.handle(info);
        }
        return this;
    }

    public void generate() {
        if (this.hasResources) {
            if (this.output == null) {
                System.out.println("No output option was selected either using 'inOutputDir' or 'withOutput' methods. Skipping generation.");
            } else {
                KubernetesList list = this.resources.generate();
                list.getItems().forEach(crd -> {
                    String version = ApiVersionUtil.trimVersion((String)crd.getApiVersion());
                    try (OutputStream outputStream = this.output.outputFor(crd.getMetadata().getName() + "-" + version + ".yml");){
                        YAML_MAPPER.writeValue(outputStream, crd);
                        System.out.println("Created " + this.output.crdURI());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        } else {
            System.out.println("No resources were registered with the 'customResources' method to be generated");
        }
    }

    static {
        YAML_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        YAML_MAPPER.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        YAML_MAPPER.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
    }

    static class DirCRDOutput
    implements CRDOutput {
        private final File dir;
        private OutputStream output;
        private URI uri;

        public DirCRDOutput(File dir) {
            if (!(dir.isDirectory() && dir.canWrite() && dir.exists())) {
                throw new IllegalArgumentException(dir + " must exist, be a writeable output directory");
            }
            this.dir = dir;
        }

        @Override
        public OutputStream outputFor(String crdFileName) throws IOException {
            File file = new File(this.dir, crdFileName);
            this.uri = file.toURI();
            this.output = new FileOutputStream(file);
            return this.output;
        }

        @Override
        public URI crdURI() {
            return this.uri;
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }

    public static interface CRDOutput
    extends Closeable {
        public OutputStream outputFor(String var1) throws IOException;

        public URI crdURI();
    }
}

