/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import io.fabric8.crd.generator.annotation.PrinterColumn;
import io.fabric8.crdv2.generator.AbstractJsonSchema;
import io.fabric8.crdv2.generator.CustomResourceInfo;
import io.fabric8.crdv2.generator.ResolvingContext;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCustomResourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonSchema.class);

    public abstract void handle(CustomResourceInfo var1, ResolvingContext var2);

    protected void handlePrinterColumns(AbstractJsonSchema<?, ?> resolver, PrinterColumnHandler handler) {
        TreeMap<String, AbstractJsonSchema.AnnotationMetadata> sortedCols = new TreeMap<String, AbstractJsonSchema.AnnotationMetadata>(String.CASE_INSENSITIVE_ORDER);
        sortedCols.putAll(resolver.getAllPaths(PrinterColumn.class));
        sortedCols.forEach((path, property) -> {
            String format;
            PrinterColumn printerColumn = (PrinterColumn)property.annotation;
            String column = printerColumn.name();
            if (Utils.isNullOrEmpty((String)column)) {
                column = path.substring(path.lastIndexOf(".") + 1).toUpperCase();
            }
            format = Utils.isNotNullOrEmpty((String)(format = printerColumn.format())) ? format : null;
            int priority = printerColumn.priority();
            String type = property.schema.getType();
            if ("object".equals(type) || "array".equals(type)) {
                LOGGER.warn("Printer column '{}' has a type '{}' that is not allowed, will use string intead", (Object)column, (Object)type);
                type = "string";
            } else if ("string".equals(type) && "date".equals(property.schema.getFormat())) {
                type = "date";
            }
            String description = property.schema.getDescription();
            description = Utils.isNotNullOrEmpty((String)description) ? description : null;
            handler.addPrinterColumn((String)path, column, format, priority, type, description);
        });
    }

    public abstract Stream<Map.Entry<? extends HasMetadata, Set<String>>> finish();

    public static interface PrinterColumnHandler {
        public void addPrinterColumn(String var1, String var2, String var3, int var4, String var5, String var6);
    }
}

