/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.Strings;
import java.util.HashMap;
import java.util.Map;

public abstract class PublicPortMapper {
    private static SPI create() {
        Class mapperClass = DefaultSPI.class;
        String mapperClassName = System.getProperty(PublicPortMapper.class.getName());
        try {
            if (mapperClassName != null) {
                if ((mapperClassName = mapperClassName.trim()).equals("default")) {
                    mapperClassName = DefaultSPI.class.getName();
                }
                if (mapperClassName.equals("openshift")) {
                    mapperClassName = OpenShiftSPI.class.getName();
                }
                try {
                    mapperClass = PublicPortMapper.class.getClassLoader().loadClass(mapperClassName);
                }
                catch (ClassNotFoundException e) {
                    mapperClass = Thread.currentThread().getContextClassLoader().loadClass(mapperClassName);
                }
            }
            return (SPI)mapperClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getPublicPort(int localPort) {
        return PublicPortMapper.create().getPublicPort(localPort);
    }

    public static class OpenShiftSPI
    extends SPI {
        HashMap<Integer, Integer> ports = new HashMap();

        public OpenShiftSPI() {
            Map<String, String> envs = System.getenv();
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                String key = entry.getKey();
                String publicPort = entry.getValue();
                if (!key.startsWith("OPENSHIFT_") || !key.endsWith("_PROXY_PORT")) continue;
                String prefix = Strings.stripSuffix(key, "_PROXY_PORT");
                String privatePort = envs.get(prefix + "_PORT");
                if (privatePort == null) {
                    privatePort = envs.get(prefix);
                }
                if (privatePort == null) continue;
                try {
                    this.ports.put(new Integer(privatePort), new Integer(publicPort));
                }
                catch (NumberFormatException ignore) {}
            }
        }

        @Override
        int getPublicPort(int localPort) {
            Integer rc = this.ports.get(localPort);
            if (rc != null) {
                return rc;
            }
            return localPort;
        }
    }

    public static class DefaultSPI
    extends SPI {
        @Override
        int getPublicPort(int localPort) {
            return localPort;
        }
    }

    public static abstract class SPI {
        abstract int getPublicPort(int var1);
    }
}

