/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.util.Map;

public class Maps {
    public static <K, V> void putAll(Map<K, V> output, Map<K, V> input, K ... keys) {
        for (K key : keys) {
            V value = input.get(key);
            if (value == null) continue;
            output.put(key, value);
        }
    }

    public static boolean booleanValue(Map<String, ?> map, String key) {
        return Maps.booleanValue(map, key, false);
    }

    public static boolean booleanValue(Map<String, ?> map, String key, boolean defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            return value;
        }
        String text = obj.toString();
        return Boolean.parseBoolean(text);
    }

    public static Object value(Map<String, Object> map, String key, Object defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public static String stringValue(Map map, String key) {
        return Maps.stringValue(map, key, null);
    }

    public static String stringValue(Map map, String key, String defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return String.valueOf(obj);
    }

    public static void setValue(Map map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        } else {
            map.remove(key);
        }
    }
}

