/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOHelpers {
    protected static final int BUFFER_SIZE = 16384;

    public static void writeTo(File file, InputStream in) throws IOException {
        IOHelpers.writeTo(file, in, 16384);
    }

    public static void writeTo(File newFile, String text) throws IOException {
        IOHelpers.writeTo(newFile, new ByteArrayInputStream(text.getBytes()));
    }

    public static void writeTo(File file, InputStream in, int bufferSize) throws IOException {
        IOHelpers.writeTo(new FileOutputStream(file), in, bufferSize, true);
    }

    public static void writeTo(OutputStream outputStream, InputStream in, boolean close) throws IOException {
        IOHelpers.writeTo(outputStream, in, 16384, close);
    }

    public static void writeTo(OutputStream outputStream, InputStream in, int bufferSize, boolean close) throws IOException {
        int b;
        BufferedOutputStream out = new BufferedOutputStream(outputStream, bufferSize);
        BufferedInputStream bufferedIn = new BufferedInputStream(in, bufferSize);
        while ((b = bufferedIn.read()) >= 0) {
            out.write(b);
        }
        in.close();
        if (close) {
            out.close();
        } else {
            out.flush();
        }
    }
}

