/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.server.mock;

import io.fabric8.certmanager.client.CertManagerClient;
import io.fabric8.certmanager.client.NamespacedCertManagerClient;
import io.fabric8.certmanager.server.mock.CertManagerMockServer;
import io.fabric8.certmanager.server.mock.EnableCertManagerMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CertManagerMockServerExtension
extends KubernetesMockServerExtension {
    private CertManagerMockServer certManagerMockServer;
    private NamespacedCertManagerClient certManagerClient;

    protected void destroy() {
        this.certManagerMockServer.destroy();
        this.certManagerClient.close();
    }

    protected Class<?> getClientType() {
        return CertManagerClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return CertManagerMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableCertManagerMockClient a = testClass.getAnnotation(EnableCertManagerMockClient.class);
        this.certManagerMockServer = a.crud() ? new CertManagerMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(Collections.emptyList()), a.https()) : new CertManagerMockServer(a.https());
        this.certManagerMockServer.init();
        this.certManagerClient = this.certManagerMockServer.createCertManager();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.certManagerClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.certManagerMockServer));
    }
}

