/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1.VaultAppRole;
import io.fabric8.certmanager.api.model.v1.VaultAppRoleBuilder;
import io.fabric8.certmanager.api.model.v1.VaultAppRoleFluent;
import io.fabric8.certmanager.api.model.v1.VaultAuth;
import io.fabric8.certmanager.api.model.v1.VaultClientCertificateAuth;
import io.fabric8.certmanager.api.model.v1.VaultClientCertificateAuthBuilder;
import io.fabric8.certmanager.api.model.v1.VaultClientCertificateAuthFluent;
import io.fabric8.certmanager.api.model.v1.VaultKubernetesAuth;
import io.fabric8.certmanager.api.model.v1.VaultKubernetesAuthBuilder;
import io.fabric8.certmanager.api.model.v1.VaultKubernetesAuthFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VaultAuthFluent<A extends VaultAuthFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private VaultAppRoleBuilder appRole;
    private VaultClientCertificateAuthBuilder clientCertificate;
    private VaultKubernetesAuthBuilder kubernetes;
    private SecretKeySelectorBuilder tokenSecretRef;

    public VaultAuthFluent() {
    }

    public VaultAuthFluent(VaultAuth instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public VaultAppRole buildAppRole() {
        return this.appRole != null ? this.appRole.build() : null;
    }

    public VaultClientCertificateAuth buildClientCertificate() {
        return this.clientCertificate != null ? this.clientCertificate.build() : null;
    }

    public VaultKubernetesAuth buildKubernetes() {
        return this.kubernetes != null ? this.kubernetes.build() : null;
    }

    public SecretKeySelector buildTokenSecretRef() {
        return this.tokenSecretRef != null ? this.tokenSecretRef.build() : null;
    }

    protected void copyInstance(VaultAuth instance) {
        VaultAuth vaultAuth = instance = instance != null ? instance : new VaultAuth();
        if (instance != null) {
            this.withAppRole(instance.getAppRole());
            this.withClientCertificate(instance.getClientCertificate());
            this.withKubernetes(instance.getKubernetes());
            this.withTokenSecretRef(instance.getTokenSecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AppRoleNested<A> editAppRole() {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(null));
    }

    public ClientCertificateNested<A> editClientCertificate() {
        return this.withNewClientCertificateLike(Optional.ofNullable(this.buildClientCertificate()).orElse(null));
    }

    public KubernetesNested<A> editKubernetes() {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(null));
    }

    public AppRoleNested<A> editOrNewAppRole() {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(new VaultAppRoleBuilder().build()));
    }

    public AppRoleNested<A> editOrNewAppRoleLike(VaultAppRole item) {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(item));
    }

    public ClientCertificateNested<A> editOrNewClientCertificate() {
        return this.withNewClientCertificateLike(Optional.ofNullable(this.buildClientCertificate()).orElse(new VaultClientCertificateAuthBuilder().build()));
    }

    public ClientCertificateNested<A> editOrNewClientCertificateLike(VaultClientCertificateAuth item) {
        return this.withNewClientCertificateLike(Optional.ofNullable(this.buildClientCertificate()).orElse(item));
    }

    public KubernetesNested<A> editOrNewKubernetes() {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(new VaultKubernetesAuthBuilder().build()));
    }

    public KubernetesNested<A> editOrNewKubernetesLike(VaultKubernetesAuth item) {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(item));
    }

    public TokenSecretRefNested<A> editOrNewTokenSecretRef() {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(item));
    }

    public TokenSecretRefNested<A> editTokenSecretRef() {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultAuthFluent that = (VaultAuthFluent)((Object)o);
        if (!Objects.equals((Object)this.appRole, (Object)that.appRole)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientCertificate, (Object)that.clientCertificate)) {
            return false;
        }
        if (!Objects.equals((Object)this.kubernetes, (Object)that.kubernetes)) {
            return false;
        }
        if (!Objects.equals((Object)this.tokenSecretRef, (Object)that.tokenSecretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAppRole() {
        return this.appRole != null;
    }

    public boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    public boolean hasKubernetes() {
        return this.kubernetes != null;
    }

    public boolean hasTokenSecretRef() {
        return this.tokenSecretRef != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appRole, this.clientCertificate, this.kubernetes, this.tokenSecretRef, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appRole != null) {
            sb.append("appRole:");
            sb.append((Object)this.appRole);
            sb.append(",");
        }
        if (this.clientCertificate != null) {
            sb.append("clientCertificate:");
            sb.append((Object)this.clientCertificate);
            sb.append(",");
        }
        if (this.kubernetes != null) {
            sb.append("kubernetes:");
            sb.append((Object)this.kubernetes);
            sb.append(",");
        }
        if (this.tokenSecretRef != null) {
            sb.append("tokenSecretRef:");
            sb.append((Object)this.tokenSecretRef);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAppRole(VaultAppRole appRole) {
        this._visitables.remove((Object)"appRole");
        if (appRole != null) {
            this.appRole = new VaultAppRoleBuilder(appRole);
            this._visitables.get((Object)"appRole").add(this.appRole);
        } else {
            this.appRole = null;
            this._visitables.get((Object)"appRole").remove((Object)this.appRole);
        }
        return (A)((Object)this);
    }

    public A withClientCertificate(VaultClientCertificateAuth clientCertificate) {
        this._visitables.remove((Object)"clientCertificate");
        if (clientCertificate != null) {
            this.clientCertificate = new VaultClientCertificateAuthBuilder(clientCertificate);
            this._visitables.get((Object)"clientCertificate").add(this.clientCertificate);
        } else {
            this.clientCertificate = null;
            this._visitables.get((Object)"clientCertificate").remove((Object)this.clientCertificate);
        }
        return (A)((Object)this);
    }

    public A withKubernetes(VaultKubernetesAuth kubernetes) {
        this._visitables.remove((Object)"kubernetes");
        if (kubernetes != null) {
            this.kubernetes = new VaultKubernetesAuthBuilder(kubernetes);
            this._visitables.get((Object)"kubernetes").add(this.kubernetes);
        } else {
            this.kubernetes = null;
            this._visitables.get((Object)"kubernetes").remove((Object)this.kubernetes);
        }
        return (A)((Object)this);
    }

    public AppRoleNested<A> withNewAppRole() {
        return new AppRoleNested(null);
    }

    public AppRoleNested<A> withNewAppRoleLike(VaultAppRole item) {
        return new AppRoleNested(item);
    }

    public ClientCertificateNested<A> withNewClientCertificate() {
        return new ClientCertificateNested(null);
    }

    public A withNewClientCertificate(String mountPath, String name, String secretName) {
        return this.withClientCertificate(new VaultClientCertificateAuth(mountPath, name, secretName));
    }

    public ClientCertificateNested<A> withNewClientCertificateLike(VaultClientCertificateAuth item) {
        return new ClientCertificateNested(item);
    }

    public KubernetesNested<A> withNewKubernetes() {
        return new KubernetesNested(null);
    }

    public KubernetesNested<A> withNewKubernetesLike(VaultKubernetesAuth item) {
        return new KubernetesNested(item);
    }

    public TokenSecretRefNested<A> withNewTokenSecretRef() {
        return new TokenSecretRefNested(null);
    }

    public A withNewTokenSecretRef(String key, String name) {
        return this.withTokenSecretRef(new SecretKeySelector(key, name));
    }

    public TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
        return new TokenSecretRefNested(item);
    }

    public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
        this._visitables.remove((Object)"tokenSecretRef");
        if (tokenSecretRef != null) {
            this.tokenSecretRef = new SecretKeySelectorBuilder(tokenSecretRef);
            this._visitables.get((Object)"tokenSecretRef").add(this.tokenSecretRef);
        } else {
            this.tokenSecretRef = null;
            this._visitables.get((Object)"tokenSecretRef").remove((Object)this.tokenSecretRef);
        }
        return (A)((Object)this);
    }

    public class TokenSecretRefNested<N>
    extends SecretKeySelectorFluent<TokenSecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        TokenSecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withTokenSecretRef(this.builder.build());
        }

        public N endTokenSecretRef() {
            return this.and();
        }
    }

    public class KubernetesNested<N>
    extends VaultKubernetesAuthFluent<KubernetesNested<N>>
    implements Nested<N> {
        VaultKubernetesAuthBuilder builder;

        KubernetesNested(VaultKubernetesAuth item) {
            this.builder = new VaultKubernetesAuthBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withKubernetes(this.builder.build());
        }

        public N endKubernetes() {
            return this.and();
        }
    }

    public class ClientCertificateNested<N>
    extends VaultClientCertificateAuthFluent<ClientCertificateNested<N>>
    implements Nested<N> {
        VaultClientCertificateAuthBuilder builder;

        ClientCertificateNested(VaultClientCertificateAuth item) {
            this.builder = new VaultClientCertificateAuthBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withClientCertificate(this.builder.build());
        }

        public N endClientCertificate() {
            return this.and();
        }
    }

    public class AppRoleNested<N>
    extends VaultAppRoleFluent<AppRoleNested<N>>
    implements Nested<N> {
        VaultAppRoleBuilder builder;

        AppRoleNested(VaultAppRole item) {
            this.builder = new VaultAppRoleBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withAppRole(this.builder.build());
        }

        public N endAppRole() {
            return this.and();
        }
    }
}

