/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1.JKSKeystore;
import io.fabric8.certmanager.api.model.v1.JKSKeystoreBuilder;
import io.fabric8.certmanager.api.model.v1.JKSKeystoreFluent;
import io.fabric8.certmanager.api.model.v1.PKCS12Keystore;
import io.fabric8.certmanager.api.model.v1.PKCS12KeystoreBuilder;
import io.fabric8.certmanager.api.model.v1.PKCS12KeystoreFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CertificateKeystoresFluent<A extends CertificateKeystoresFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private JKSKeystoreBuilder jks;
    private PKCS12KeystoreBuilder pkcs12;

    public CertificateKeystoresFluent() {
    }

    public CertificateKeystoresFluent(CertificateKeystores instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public JKSKeystore buildJks() {
        return this.jks != null ? this.jks.build() : null;
    }

    public PKCS12Keystore buildPkcs12() {
        return this.pkcs12 != null ? this.pkcs12.build() : null;
    }

    protected void copyInstance(CertificateKeystores instance) {
        CertificateKeystores certificateKeystores = instance = instance != null ? instance : new CertificateKeystores();
        if (instance != null) {
            this.withJks(instance.getJks());
            this.withPkcs12(instance.getPkcs12());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public JksNested<A> editJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(null));
    }

    public JksNested<A> editOrNewJks() {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(new JKSKeystoreBuilder().build()));
    }

    public JksNested<A> editOrNewJksLike(JKSKeystore item) {
        return this.withNewJksLike(Optional.ofNullable(this.buildJks()).orElse(item));
    }

    public Pkcs12Nested<A> editOrNewPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(new PKCS12KeystoreBuilder().build()));
    }

    public Pkcs12Nested<A> editOrNewPkcs12Like(PKCS12Keystore item) {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(item));
    }

    public Pkcs12Nested<A> editPkcs12() {
        return this.withNewPkcs12Like(Optional.ofNullable(this.buildPkcs12()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateKeystoresFluent that = (CertificateKeystoresFluent)((Object)o);
        if (!Objects.equals((Object)this.jks, (Object)that.jks)) {
            return false;
        }
        if (!Objects.equals((Object)this.pkcs12, (Object)that.pkcs12)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasJks() {
        return this.jks != null;
    }

    public boolean hasPkcs12() {
        return this.pkcs12 != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jks, this.pkcs12, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jks != null) {
            sb.append("jks:");
            sb.append((Object)this.jks);
            sb.append(",");
        }
        if (this.pkcs12 != null) {
            sb.append("pkcs12:");
            sb.append((Object)this.pkcs12);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withJks(JKSKeystore jks) {
        this._visitables.remove((Object)"jks");
        if (jks != null) {
            this.jks = new JKSKeystoreBuilder(jks);
            this._visitables.get((Object)"jks").add(this.jks);
        } else {
            this.jks = null;
            this._visitables.get((Object)"jks").remove((Object)this.jks);
        }
        return (A)((Object)this);
    }

    public JksNested<A> withNewJks() {
        return new JksNested(null);
    }

    public JksNested<A> withNewJksLike(JKSKeystore item) {
        return new JksNested(item);
    }

    public Pkcs12Nested<A> withNewPkcs12() {
        return new Pkcs12Nested(null);
    }

    public Pkcs12Nested<A> withNewPkcs12Like(PKCS12Keystore item) {
        return new Pkcs12Nested(item);
    }

    public A withPkcs12(PKCS12Keystore pkcs12) {
        this._visitables.remove((Object)"pkcs12");
        if (pkcs12 != null) {
            this.pkcs12 = new PKCS12KeystoreBuilder(pkcs12);
            this._visitables.get((Object)"pkcs12").add(this.pkcs12);
        } else {
            this.pkcs12 = null;
            this._visitables.get((Object)"pkcs12").remove((Object)this.pkcs12);
        }
        return (A)((Object)this);
    }

    public class Pkcs12Nested<N>
    extends PKCS12KeystoreFluent<Pkcs12Nested<N>>
    implements Nested<N> {
        PKCS12KeystoreBuilder builder;

        Pkcs12Nested(PKCS12Keystore item) {
            this.builder = new PKCS12KeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withPkcs12(this.builder.build());
        }

        public N endPkcs12() {
            return this.and();
        }
    }

    public class JksNested<N>
    extends JKSKeystoreFluent<JksNested<N>>
    implements Nested<N> {
        JKSKeystoreBuilder builder;

        JksNested(JKSKeystore item) {
            this.builder = new JKSKeystoreBuilder(this, item);
        }

        public N and() {
            return (N)CertificateKeystoresFluent.this.withJks(this.builder.build());
        }

        public N endJks() {
            return this.and();
        }
    }
}

