/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1.ACMEAuthorizationBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEAuthorizationFluent;
import io.fabric8.certmanager.api.model.acme.v1.OrderStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OrderStatusFluent<A extends OrderStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ACMEAuthorizationBuilder> authorizations = new ArrayList();
    private String certificate;
    private String failureTime;
    private String finalizeURL;
    private String reason;
    private String state;
    private String url;

    public OrderStatusFluent() {
    }

    public OrderStatusFluent(OrderStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)((Object)this);
    }

    public AuthorizationsNested<A> addNewAuthorization() {
        return new AuthorizationsNested(-1, null);
    }

    public AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
        return new AuthorizationsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAuthorizations(ACMEAuthorization ... items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        if (index < 0 || index >= this.authorizations.size()) {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        } else {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ACMEAuthorization buildAuthorization(int index) {
        return this.authorizations.get(index).build();
    }

    public List<ACMEAuthorization> buildAuthorizations() {
        return this.authorizations != null ? OrderStatusFluent.build(this.authorizations) : null;
    }

    public ACMEAuthorization buildFirstAuthorization() {
        return this.authorizations.get(0).build();
    }

    public ACMEAuthorization buildLastAuthorization() {
        return this.authorizations.get(this.authorizations.size() - 1).build();
    }

    public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(OrderStatus instance) {
        OrderStatus orderStatus = instance = instance != null ? instance : new OrderStatus();
        if (instance != null) {
            this.withAuthorizations(instance.getAuthorizations());
            this.withCertificate(instance.getCertificate());
            this.withFailureTime(instance.getFailureTime());
            this.withFinalizeURL(instance.getFinalizeURL());
            this.withReason(instance.getReason());
            this.withState(instance.getState());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AuthorizationsNested<A> editAuthorization(int index) {
        if (this.authorizations.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "authorizations"));
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    public AuthorizationsNested<A> editFirstAuthorization() {
        if (this.authorizations.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "authorizations"));
        }
        return this.setNewAuthorizationLike(0, this.buildAuthorization(0));
    }

    public AuthorizationsNested<A> editLastAuthorization() {
        int index = this.authorizations.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "authorizations"));
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    public AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authorizations.size(); ++i) {
            if (!predicate.test(this.authorizations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "authorizations"));
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderStatusFluent that = (OrderStatusFluent)((Object)o);
        if (!Objects.equals(this.authorizations, that.authorizations)) {
            return false;
        }
        if (!Objects.equals(this.certificate, that.certificate)) {
            return false;
        }
        if (!Objects.equals(this.failureTime, that.failureTime)) {
            return false;
        }
        if (!Objects.equals(this.finalizeURL, that.finalizeURL)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getFailureTime() {
        return this.failureTime;
    }

    public String getFinalizeURL() {
        return this.finalizeURL;
    }

    public String getReason() {
        return this.reason;
    }

    public String getState() {
        return this.state;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuthorizations() {
        return this.authorizations != null && !this.authorizations.isEmpty();
    }

    public boolean hasCertificate() {
        return this.certificate != null;
    }

    public boolean hasFailureTime() {
        return this.failureTime != null;
    }

    public boolean hasFinalizeURL() {
        return this.finalizeURL != null;
    }

    public boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public int hashCode() {
        return Objects.hash(this.authorizations, this.certificate, this.failureTime, this.finalizeURL, this.reason, this.state, this.url, this.additionalProperties);
    }

    public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
        if (this.authorizations == null) {
            return (A)((Object)this);
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove((Object)builder);
            this.authorizations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAuthorizations(ACMEAuthorization ... items) {
        if (this.authorizations == null) {
            return (A)((Object)this);
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove((Object)builder);
            this.authorizations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
        if (this.authorizations == null) {
            return (A)((Object)this);
        }
        Iterator<ACMEAuthorizationBuilder> each = this.authorizations.iterator();
        List visitables = this._visitables.get((Object)"authorizations");
        while (each.hasNext()) {
            ACMEAuthorizationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AuthorizationsNested<A> setNewAuthorizationLike(int index, ACMEAuthorization item) {
        return new AuthorizationsNested(index, item);
    }

    public A setToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        if (index < 0 || index >= this.authorizations.size()) {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        } else {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorizations != null && !this.authorizations.isEmpty()) {
            sb.append("authorizations:");
            sb.append(this.authorizations);
            sb.append(",");
        }
        if (this.certificate != null) {
            sb.append("certificate:");
            sb.append(this.certificate);
            sb.append(",");
        }
        if (this.failureTime != null) {
            sb.append("failureTime:");
            sb.append(this.failureTime);
            sb.append(",");
        }
        if (this.finalizeURL != null) {
            sb.append("finalizeURL:");
            sb.append(this.finalizeURL);
            sb.append(",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason);
            sb.append(",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuthorizations(List<ACMEAuthorization> authorizations) {
        if (this.authorizations != null) {
            this._visitables.get((Object)"authorizations").clear();
        }
        if (authorizations != null) {
            this.authorizations = new ArrayList();
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        } else {
            this.authorizations = null;
        }
        return (A)((Object)this);
    }

    public A withAuthorizations(ACMEAuthorization ... authorizations) {
        if (this.authorizations != null) {
            this.authorizations.clear();
            this._visitables.remove((Object)"authorizations");
        }
        if (authorizations != null) {
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCertificate(String certificate) {
        this.certificate = certificate;
        return (A)((Object)this);
    }

    public A withFailureTime(String failureTime) {
        this.failureTime = failureTime;
        return (A)((Object)this);
    }

    public A withFinalizeURL(String finalizeURL) {
        this.finalizeURL = finalizeURL;
        return (A)((Object)this);
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public A withState(String state) {
        this.state = state;
        return (A)((Object)this);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public class AuthorizationsNested<N>
    extends ACMEAuthorizationFluent<AuthorizationsNested<N>>
    implements Nested<N> {
        ACMEAuthorizationBuilder builder;
        int index;

        AuthorizationsNested(int index, ACMEAuthorization item) {
            this.index = index;
            this.builder = new ACMEAuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)OrderStatusFluent.this.setToAuthorizations(this.index, this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

