/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.certmanager.api.model.acme.v1.OrderSpec;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OrderSpecFluent<A extends OrderSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String commonName;
    private List<String> dnsNames = new ArrayList<String>();
    private Duration duration;
    private List<String> ipAddresses = new ArrayList<String>();
    private ObjectReferenceBuilder issuerRef;
    private String profile;
    private String request;

    public OrderSpecFluent() {
    }

    public OrderSpecFluent(OrderSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)((Object)this);
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    protected void copyInstance(OrderSpec instance) {
        OrderSpec orderSpec = instance = instance != null ? instance : new OrderSpec();
        if (instance != null) {
            this.withCommonName(instance.getCommonName());
            this.withDnsNames(instance.getDnsNames());
            this.withDuration(instance.getDuration());
            this.withIpAddresses(instance.getIpAddresses());
            this.withIssuerRef(instance.getIssuerRef());
            this.withProfile(instance.getProfile());
            this.withRequest(instance.getRequest());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderSpecFluent that = (OrderSpecFluent)((Object)o);
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    public String getIpAddress(int index) {
        return this.ipAddresses.get(index);
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getRequest() {
        return this.request;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCommonName() {
        return this.commonName != null;
    }

    public boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonName, this.dnsNames, this.duration, this.ipAddresses, this.issuerRef, this.profile, this.request, this.additionalProperties});
    }

    public A removeAllFromDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromDnsNames(String ... items) {
        if (this.dnsNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddresses(int index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commonName != null) {
            sb.append("commonName:");
            sb.append(this.commonName);
            sb.append(",");
        }
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames);
            sb.append(",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration);
            sb.append(",");
        }
        if (this.ipAddresses != null && !this.ipAddresses.isEmpty()) {
            sb.append("ipAddresses:");
            sb.append(this.ipAddresses);
            sb.append(",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)this.issuerRef);
            sb.append(",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile);
            sb.append(",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)((Object)this);
    }

    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)((Object)this);
    }

    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
            this._visitables.remove((Object)"ipAddresses");
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)((Object)this);
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)OrderSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

