/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolver;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolverBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeSolverFluent;
import io.fabric8.certmanager.api.model.acme.v1.ChallengeSpec;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ChallengeSpecFluent<A extends ChallengeSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String authorizationURL;
    private String dnsName;
    private ObjectReferenceBuilder issuerRef;
    private String key;
    private ACMEChallengeSolverBuilder solver;
    private String token;
    private String type;
    private String url;
    private Boolean wildcard;

    public ChallengeSpecFluent() {
    }

    public ChallengeSpecFluent(ChallengeSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public ACMEChallengeSolver buildSolver() {
        return this.solver != null ? this.solver.build() : null;
    }

    protected void copyInstance(ChallengeSpec instance) {
        ChallengeSpec challengeSpec = instance = instance != null ? instance : new ChallengeSpec();
        if (instance != null) {
            this.withAuthorizationURL(instance.getAuthorizationURL());
            this.withDnsName(instance.getDnsName());
            this.withIssuerRef(instance.getIssuerRef());
            this.withKey(instance.getKey());
            this.withSolver(instance.getSolver());
            this.withToken(instance.getToken());
            this.withType(instance.getType());
            this.withUrl(instance.getUrl());
            this.withWildcard(instance.getWildcard());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public SolverNested<A> editOrNewSolver() {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(new ACMEChallengeSolverBuilder().build()));
    }

    public SolverNested<A> editOrNewSolverLike(ACMEChallengeSolver item) {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(item));
    }

    public SolverNested<A> editSolver() {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChallengeSpecFluent that = (ChallengeSpecFluent)((Object)o);
        if (!Objects.equals(this.authorizationURL, that.authorizationURL)) {
            return false;
        }
        if (!Objects.equals(this.dnsName, that.dnsName)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals((Object)this.solver, (Object)that.solver)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.wildcard, that.wildcard)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAuthorizationURL() {
        return this.authorizationURL;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getKey() {
        return this.key;
    }

    public String getToken() {
        return this.token;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuthorizationURL() {
        return this.authorizationURL != null;
    }

    public boolean hasDnsName() {
        return this.dnsName != null;
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasSolver() {
        return this.solver != null;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean hasWildcard() {
        return this.wildcard != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationURL, this.dnsName, this.issuerRef, this.key, this.solver, this.token, this.type, this.url, this.wildcard, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorizationURL != null) {
            sb.append("authorizationURL:");
            sb.append(this.authorizationURL);
            sb.append(",");
        }
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName);
            sb.append(",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)this.issuerRef);
            sb.append(",");
        }
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key);
            sb.append(",");
        }
        if (this.solver != null) {
            sb.append("solver:");
            sb.append((Object)this.solver);
            sb.append(",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.wildcard != null) {
            sb.append("wildcard:");
            sb.append(this.wildcard);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuthorizationURL(String authorizationURL) {
        this.authorizationURL = authorizationURL;
        return (A)((Object)this);
    }

    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)((Object)this);
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public SolverNested<A> withNewSolver() {
        return new SolverNested(null);
    }

    public SolverNested<A> withNewSolverLike(ACMEChallengeSolver item) {
        return new SolverNested(item);
    }

    public A withSolver(ACMEChallengeSolver solver) {
        this._visitables.remove((Object)"solver");
        if (solver != null) {
            this.solver = new ACMEChallengeSolverBuilder(solver);
            this._visitables.get((Object)"solver").add(this.solver);
        } else {
            this.solver = null;
            this._visitables.get((Object)"solver").remove((Object)this.solver);
        }
        return (A)((Object)this);
    }

    public A withToken(String token) {
        this.token = token;
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public A withWildcard() {
        return this.withWildcard(true);
    }

    public A withWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return (A)((Object)this);
    }

    public class SolverNested<N>
    extends ACMEChallengeSolverFluent<SolverNested<N>>
    implements Nested<N> {
        ACMEChallengeSolverBuilder builder;

        SolverNested(ACMEChallengeSolver item) {
            this.builder = new ACMEChallengeSolverBuilder(this, item);
        }

        public N and() {
            return (N)ChallengeSpecFluent.this.withSolver(this.builder.build());
        }

        public N endSolver() {
            return this.and();
        }
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ChallengeSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

