/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1;

import io.fabric8.certmanager.api.model.acme.v1.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallenge;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeBuilder;
import io.fabric8.certmanager.api.model.acme.v1.ACMEChallengeFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ACMEAuthorizationFluent<A extends ACMEAuthorizationFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ACMEChallengeBuilder> challenges = new ArrayList();
    private String identifier;
    private String initialState;
    private String url;
    private Boolean wildcard;

    public ACMEAuthorizationFluent() {
    }

    public ACMEAuthorizationFluent(ACMEAuthorization instance) {
        this.copyInstance(instance);
    }

    public A addAllToChallenges(Collection<ACMEChallenge> items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)((Object)this);
    }

    public ChallengesNested<A> addNewChallenge() {
        return new ChallengesNested(-1, null);
    }

    public A addNewChallenge(String token, String type, String url) {
        return this.addToChallenges(new ACMEChallenge(token, type, url));
    }

    public ChallengesNested<A> addNewChallengeLike(ACMEChallenge item) {
        return new ChallengesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToChallenges(ACMEChallenge ... items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToChallenges(int index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        if (index < 0 || index >= this.challenges.size()) {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        } else {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ACMEChallenge buildChallenge(int index) {
        return this.challenges.get(index).build();
    }

    public List<ACMEChallenge> buildChallenges() {
        return this.challenges != null ? ACMEAuthorizationFluent.build(this.challenges) : null;
    }

    public ACMEChallenge buildFirstChallenge() {
        return this.challenges.get(0).build();
    }

    public ACMEChallenge buildLastChallenge() {
        return this.challenges.get(this.challenges.size() - 1).build();
    }

    public ACMEChallenge buildMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ACMEAuthorization instance) {
        ACMEAuthorization aCMEAuthorization = instance = instance != null ? instance : new ACMEAuthorization();
        if (instance != null) {
            this.withChallenges(instance.getChallenges());
            this.withIdentifier(instance.getIdentifier());
            this.withInitialState(instance.getInitialState());
            this.withUrl(instance.getUrl());
            this.withWildcard(instance.getWildcard());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ChallengesNested<A> editChallenge(int index) {
        if (this.challenges.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "challenges"));
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public ChallengesNested<A> editFirstChallenge() {
        if (this.challenges.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "challenges"));
        }
        return this.setNewChallengeLike(0, this.buildChallenge(0));
    }

    public ChallengesNested<A> editLastChallenge() {
        int index = this.challenges.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "challenges"));
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public ChallengesNested<A> editMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.challenges.size(); ++i) {
            if (!predicate.test(this.challenges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "challenges"));
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ACMEAuthorizationFluent that = (ACMEAuthorizationFluent)((Object)o);
        if (!Objects.equals(this.challenges, that.challenges)) {
            return false;
        }
        if (!Objects.equals(this.identifier, that.identifier)) {
            return false;
        }
        if (!Objects.equals(this.initialState, that.initialState)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.wildcard, that.wildcard)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasChallenges() {
        return this.challenges != null && !this.challenges.isEmpty();
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public boolean hasInitialState() {
        return this.initialState != null;
    }

    public boolean hasMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean hasWildcard() {
        return this.wildcard != null;
    }

    public int hashCode() {
        return Objects.hash(this.challenges, this.identifier, this.initialState, this.url, this.wildcard, this.additionalProperties);
    }

    public A removeAllFromChallenges(Collection<ACMEChallenge> items) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove((Object)builder);
            this.challenges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromChallenges(ACMEChallenge ... items) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove((Object)builder);
            this.challenges.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromChallenges(Predicate<ACMEChallengeBuilder> predicate) {
        if (this.challenges == null) {
            return (A)((Object)this);
        }
        Iterator<ACMEChallengeBuilder> each = this.challenges.iterator();
        List visitables = this._visitables.get((Object)"challenges");
        while (each.hasNext()) {
            ACMEChallengeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ChallengesNested<A> setNewChallengeLike(int index, ACMEChallenge item) {
        return new ChallengesNested(index, item);
    }

    public A setToChallenges(int index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        if (index < 0 || index >= this.challenges.size()) {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        } else {
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.challenges != null && !this.challenges.isEmpty()) {
            sb.append("challenges:");
            sb.append(this.challenges);
            sb.append(",");
        }
        if (this.identifier != null) {
            sb.append("identifier:");
            sb.append(this.identifier);
            sb.append(",");
        }
        if (this.initialState != null) {
            sb.append("initialState:");
            sb.append(this.initialState);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.wildcard != null) {
            sb.append("wildcard:");
            sb.append(this.wildcard);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withChallenges(List<ACMEChallenge> challenges) {
        if (this.challenges != null) {
            this._visitables.get((Object)"challenges").clear();
        }
        if (challenges != null) {
            this.challenges = new ArrayList();
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        } else {
            this.challenges = null;
        }
        return (A)((Object)this);
    }

    public A withChallenges(ACMEChallenge ... challenges) {
        if (this.challenges != null) {
            this.challenges.clear();
            this._visitables.remove((Object)"challenges");
        }
        if (challenges != null) {
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        }
        return (A)((Object)this);
    }

    public A withIdentifier(String identifier) {
        this.identifier = identifier;
        return (A)((Object)this);
    }

    public A withInitialState(String initialState) {
        this.initialState = initialState;
        return (A)((Object)this);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public A withWildcard() {
        return this.withWildcard(true);
    }

    public A withWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return (A)((Object)this);
    }

    public class ChallengesNested<N>
    extends ACMEChallengeFluent<ChallengesNested<N>>
    implements Nested<N> {
        ACMEChallengeBuilder builder;
        int index;

        ChallengesNested(int index, ACMEChallenge item) {
            this.index = index;
            this.builder = new ACMEChallengeBuilder(this, item);
        }

        public N and() {
            return (N)ACMEAuthorizationFluent.this.setToChallenges(this.index, this.builder.build());
        }

        public N endChallenge() {
            return this.and();
        }
    }
}

