package io.fabric8.certmanager.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VaultAppRoleBuilder extends VaultAppRoleFluent<VaultAppRoleBuilder> implements VisitableBuilder<VaultAppRole,VaultAppRoleBuilder>{
  public VaultAppRoleBuilder() {
    this(new VaultAppRole());
  }
  
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent) {
    this(fluent, new VaultAppRole());
  }
  
  public VaultAppRoleBuilder(VaultAppRoleFluent<?> fluent,VaultAppRole instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VaultAppRoleBuilder(VaultAppRole instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VaultAppRoleFluent<?> fluent;
  
  public VaultAppRole build() {
    VaultAppRole buildable = new VaultAppRole(fluent.getPath(),fluent.getRoleId(),fluent.buildSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}