package io.fabric8.certmanager.api.model.acme.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureManagedIdentityFluent<A extends AzureManagedIdentityFluent<A>> extends BaseFluent<A>{
  public AzureManagedIdentityFluent() {
  }
  
  public AzureManagedIdentityFluent(AzureManagedIdentity instance) {
    this.copyInstance(instance);
  }
  private String clientID;
  private String resourceID;
  private String tenantID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureManagedIdentity instance) {
    instance = (instance != null ? instance : new AzureManagedIdentity());
    if (instance != null) {
          this.withClientID(instance.getClientID());
          this.withResourceID(instance.getResourceID());
          this.withTenantID(instance.getTenantID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientID() {
    return this.clientID;
  }
  
  public A withClientID(String clientID) {
    this.clientID = clientID;
    return (A) this;
  }
  
  public boolean hasClientID() {
    return this.clientID != null;
  }
  
  public String getResourceID() {
    return this.resourceID;
  }
  
  public A withResourceID(String resourceID) {
    this.resourceID = resourceID;
    return (A) this;
  }
  
  public boolean hasResourceID() {
    return this.resourceID != null;
  }
  
  public String getTenantID() {
    return this.tenantID;
  }
  
  public A withTenantID(String tenantID) {
    this.tenantID = tenantID;
    return (A) this;
  }
  
  public boolean hasTenantID() {
    return this.tenantID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureManagedIdentityFluent that = (AzureManagedIdentityFluent) o;
    if (!java.util.Objects.equals(clientID, that.clientID)) return false;
    if (!java.util.Objects.equals(resourceID, that.resourceID)) return false;
    if (!java.util.Objects.equals(tenantID, that.tenantID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientID,  resourceID,  tenantID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (resourceID != null) { sb.append("resourceID:"); sb.append(resourceID + ","); }
    if (tenantID != null) { sb.append("tenantID:"); sb.append(tenantID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}