/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.v1.NameConstraintItem;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NameConstraintItemFluent<A extends NameConstraintItemFluent<A>>
extends BaseFluent<A> {
    private List<String> dnsDomains = new ArrayList<String>();
    private List<String> emailAddresses = new ArrayList<String>();
    private List<String> ipRanges = new ArrayList<String>();
    private List<String> uriDomains = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NameConstraintItemFluent() {
    }

    public NameConstraintItemFluent(NameConstraintItem instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NameConstraintItem instance) {
        NameConstraintItem nameConstraintItem = instance = instance != null ? instance : new NameConstraintItem();
        if (instance != null) {
            this.withDnsDomains(instance.getDnsDomains());
            this.withEmailAddresses(instance.getEmailAddresses());
            this.withIpRanges(instance.getIpRanges());
            this.withUriDomains(instance.getUriDomains());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDnsDomains(int index, String item) {
        if (this.dnsDomains == null) {
            this.dnsDomains = new ArrayList<String>();
        }
        this.dnsDomains.add(index, item);
        return (A)((Object)this);
    }

    public A setToDnsDomains(int index, String item) {
        if (this.dnsDomains == null) {
            this.dnsDomains = new ArrayList<String>();
        }
        this.dnsDomains.set(index, item);
        return (A)((Object)this);
    }

    public A addToDnsDomains(String ... items) {
        if (this.dnsDomains == null) {
            this.dnsDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsDomains.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDnsDomains(Collection<String> items) {
        if (this.dnsDomains == null) {
            this.dnsDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsDomains.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDnsDomains(String ... items) {
        if (this.dnsDomains == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsDomains.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDnsDomains(Collection<String> items) {
        if (this.dnsDomains == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dnsDomains.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDnsDomains() {
        return this.dnsDomains;
    }

    public String getDnsDomain(int index) {
        return this.dnsDomains.get(index);
    }

    public String getFirstDnsDomain() {
        return this.dnsDomains.get(0);
    }

    public String getLastDnsDomain() {
        return this.dnsDomains.get(this.dnsDomains.size() - 1);
    }

    public String getMatchingDnsDomain(Predicate<String> predicate) {
        for (String item : this.dnsDomains) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDnsDomain(Predicate<String> predicate) {
        for (String item : this.dnsDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDnsDomains(List<String> dnsDomains) {
        if (dnsDomains != null) {
            this.dnsDomains = new ArrayList<String>();
            for (String item : dnsDomains) {
                this.addToDnsDomains(item);
            }
        } else {
            this.dnsDomains = null;
        }
        return (A)((Object)this);
    }

    public A withDnsDomains(String ... dnsDomains) {
        if (this.dnsDomains != null) {
            this.dnsDomains.clear();
            this._visitables.remove((Object)"dnsDomains");
        }
        if (dnsDomains != null) {
            for (String item : dnsDomains) {
                this.addToDnsDomains(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDnsDomains() {
        return this.dnsDomains != null && !this.dnsDomains.isEmpty();
    }

    public A addToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToEmailAddresses(int index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.emailAddresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public String getEmailAddress(int index) {
        return this.emailAddresses.get(index);
    }

    public String getFirstEmailAddress() {
        return this.emailAddresses.get(0);
    }

    public String getLastEmailAddress() {
        return this.emailAddresses.get(this.emailAddresses.size() - 1);
    }

    public String getMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEmailAddresses(List<String> emailAddresses) {
        if (emailAddresses != null) {
            this.emailAddresses = new ArrayList<String>();
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        } else {
            this.emailAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withEmailAddresses(String ... emailAddresses) {
        if (this.emailAddresses != null) {
            this.emailAddresses.clear();
            this._visitables.remove((Object)"emailAddresses");
        }
        if (emailAddresses != null) {
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEmailAddresses() {
        return this.emailAddresses != null && !this.emailAddresses.isEmpty();
    }

    public A addToIpRanges(int index, String item) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<String>();
        }
        this.ipRanges.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpRanges(int index, String item) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<String>();
        }
        this.ipRanges.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpRanges(String ... items) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpRanges(Collection<String> items) {
        if (this.ipRanges == null) {
            this.ipRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpRanges(String ... items) {
        if (this.ipRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpRanges(Collection<String> items) {
        if (this.ipRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpRanges() {
        return this.ipRanges;
    }

    public String getIpRange(int index) {
        return this.ipRanges.get(index);
    }

    public String getFirstIpRange() {
        return this.ipRanges.get(0);
    }

    public String getLastIpRange() {
        return this.ipRanges.get(this.ipRanges.size() - 1);
    }

    public String getMatchingIpRange(Predicate<String> predicate) {
        for (String item : this.ipRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpRange(Predicate<String> predicate) {
        for (String item : this.ipRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpRanges(List<String> ipRanges) {
        if (ipRanges != null) {
            this.ipRanges = new ArrayList<String>();
            for (String item : ipRanges) {
                this.addToIpRanges(item);
            }
        } else {
            this.ipRanges = null;
        }
        return (A)((Object)this);
    }

    public A withIpRanges(String ... ipRanges) {
        if (this.ipRanges != null) {
            this.ipRanges.clear();
            this._visitables.remove((Object)"ipRanges");
        }
        if (ipRanges != null) {
            for (String item : ipRanges) {
                this.addToIpRanges(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpRanges() {
        return this.ipRanges != null && !this.ipRanges.isEmpty();
    }

    public A addToUriDomains(int index, String item) {
        if (this.uriDomains == null) {
            this.uriDomains = new ArrayList<String>();
        }
        this.uriDomains.add(index, item);
        return (A)((Object)this);
    }

    public A setToUriDomains(int index, String item) {
        if (this.uriDomains == null) {
            this.uriDomains = new ArrayList<String>();
        }
        this.uriDomains.set(index, item);
        return (A)((Object)this);
    }

    public A addToUriDomains(String ... items) {
        if (this.uriDomains == null) {
            this.uriDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.uriDomains.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUriDomains(Collection<String> items) {
        if (this.uriDomains == null) {
            this.uriDomains = new ArrayList<String>();
        }
        for (String item : items) {
            this.uriDomains.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUriDomains(String ... items) {
        if (this.uriDomains == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uriDomains.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUriDomains(Collection<String> items) {
        if (this.uriDomains == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.uriDomains.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUriDomains() {
        return this.uriDomains;
    }

    public String getUriDomain(int index) {
        return this.uriDomains.get(index);
    }

    public String getFirstUriDomain() {
        return this.uriDomains.get(0);
    }

    public String getLastUriDomain() {
        return this.uriDomains.get(this.uriDomains.size() - 1);
    }

    public String getMatchingUriDomain(Predicate<String> predicate) {
        for (String item : this.uriDomains) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUriDomain(Predicate<String> predicate) {
        for (String item : this.uriDomains) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUriDomains(List<String> uriDomains) {
        if (uriDomains != null) {
            this.uriDomains = new ArrayList<String>();
            for (String item : uriDomains) {
                this.addToUriDomains(item);
            }
        } else {
            this.uriDomains = null;
        }
        return (A)((Object)this);
    }

    public A withUriDomains(String ... uriDomains) {
        if (this.uriDomains != null) {
            this.uriDomains.clear();
            this._visitables.remove((Object)"uriDomains");
        }
        if (uriDomains != null) {
            for (String item : uriDomains) {
                this.addToUriDomains(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUriDomains() {
        return this.uriDomains != null && !this.uriDomains.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NameConstraintItemFluent that = (NameConstraintItemFluent)((Object)o);
        if (!Objects.equals(this.dnsDomains, that.dnsDomains)) {
            return false;
        }
        if (!Objects.equals(this.emailAddresses, that.emailAddresses)) {
            return false;
        }
        if (!Objects.equals(this.ipRanges, that.ipRanges)) {
            return false;
        }
        if (!Objects.equals(this.uriDomains, that.uriDomains)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dnsDomains, this.emailAddresses, this.ipRanges, this.uriDomains, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsDomains != null && !this.dnsDomains.isEmpty()) {
            sb.append("dnsDomains:");
            sb.append(String.valueOf(this.dnsDomains) + ",");
        }
        if (this.emailAddresses != null && !this.emailAddresses.isEmpty()) {
            sb.append("emailAddresses:");
            sb.append(String.valueOf(this.emailAddresses) + ",");
        }
        if (this.ipRanges != null && !this.ipRanges.isEmpty()) {
            sb.append("ipRanges:");
            sb.append(String.valueOf(this.ipRanges) + ",");
        }
        if (this.uriDomains != null && !this.uriDomains.isEmpty()) {
            sb.append("uriDomains:");
            sb.append(String.valueOf(this.uriDomains) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

