/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.mapping;

import de.pdark.decentxml.Node;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.mapping.AbstractNodeHandler;
import de.pdark.decentxml.mapping.INodeHandler;
import de.pdark.decentxml.mapping.MappingException;
import de.pdark.decentxml.mapping.NoParametersHandler;
import de.pdark.decentxml.mapping.NopHandler;
import java.lang.reflect.Method;

public class TextHandlerFactory {
    public static INodeHandler create(Object handler, Method method) {
        if (method == null) {
            return new NopHandler();
        }
        if (method.getParameterTypes().length == 0) {
            return new NoParametersHandler(handler, method);
        }
        if (method.getParameterTypes().length == 1) {
            Class<?> type = method.getParameterTypes()[0];
            if (String.class.equals(type)) {
                return new StringTextHandler(handler, method);
            }
            if (Text.class.isAssignableFrom(type)) {
                return new TextObjectTextHandler(handler, method);
            }
        }
        throw new MappingException("Can't create a text handler for " + method);
    }

    public static class TextObjectTextHandler
    extends AbstractNodeHandler {
        public TextObjectTextHandler(Object handler, Method method) {
            super(handler, method);
        }

        public void invoke(Node node) throws Exception {
            this.method.invoke(this.handler, node);
        }
    }

    public static class StringTextHandler
    extends AbstractNodeHandler {
        public StringTextHandler(Object handler, Method method) {
            super(handler, method);
        }

        public void invoke(Node node) throws Exception {
            String text = ((Text)node).getText();
            this.method.invoke(this.handler, text);
        }
    }
}

