/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.domain;

import io.eventuate.CompletableFutureUtil;
import io.eventuate.DispatchedEvent;
import io.eventuate.Event;
import io.eventuate.EventuateAggregateStoreCrud;
import io.eventuate.javaclient.domain.EventHandler;
import io.eventuate.javaclient.domain.EventHandlerContextImpl;
import io.eventuate.javaclient.domain.EventHandlerProcessorUtil;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.builder.ToStringBuilder;

class EventHandlerContextReturningCompletableFuture
implements EventHandler {
    private final Method method;
    private final Object eventHandler;
    private EventuateAggregateStoreCrud aggregateStore;

    public EventHandlerContextReturningCompletableFuture(EventuateAggregateStoreCrud aggregateStore, Method method, Object eventHandler) {
        this.aggregateStore = aggregateStore;
        this.method = method;
        this.eventHandler = eventHandler;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method.getName()).toString();
    }

    @Override
    public Class<Event> getEventType() {
        return EventHandlerProcessorUtil.getEventClass(this.method);
    }

    @Override
    public CompletableFuture<?> dispatch(DispatchedEvent<Event> de) {
        try {
            return (CompletableFuture)this.method.invoke(this.eventHandler, new EventHandlerContextImpl(this.aggregateStore, de));
        }
        catch (Throwable e) {
            return CompletableFutureUtil.failedFuture((Throwable)e);
        }
    }
}

