/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.buffer.impl.VertxHeapByteBuf;
import io.vertx.core.buffer.impl.VertxUnsafeHeapByteBuf;

public abstract class VertxByteBufAllocator
extends AbstractByteBufAllocator {
    public static final ByteBufAllocator POOLED_ALLOCATOR;
    private static final VertxByteBufAllocator UNSAFE_IMPL;
    private static final VertxByteBufAllocator IMPL;
    public static final VertxByteBufAllocator DEFAULT;

    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return UnpooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }

    static {
        ByteBufAllocator pooledAllocator = ByteBufAllocator.DEFAULT;
        if (pooledAllocator instanceof UnpooledByteBufAllocator) {
            pooledAllocator = new AdaptiveByteBufAllocator();
        }
        POOLED_ALLOCATOR = pooledAllocator;
        UNSAFE_IMPL = new VertxByteBufAllocator(){

            @Override
            protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
                return new VertxUnsafeHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
            }
        };
        IMPL = new VertxByteBufAllocator(){

            @Override
            protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
                return new VertxHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
            }
        };
        DEFAULT = PlatformDependent.hasUnsafe() ? UNSAFE_IMPL : IMPL;
    }
}

