/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.channel.AddressedEnvelope;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.datagram.impl.InternetProtocolFamily;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.DnsException;
import io.vertx.core.dns.DnsResponseCode;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.DnsAddressResolverProvider;
import io.vertx.core.dns.impl.RecordDecoder;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DnsClientImpl
implements DnsClient {
    public static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private static final Function<List<String>, @Nullable String> FIRST_OF = lst -> lst.size() > 0 ? (String)lst.get(0) : null;
    private final VertxInternal vertx;
    private boolean closed;
    private final Map<EventLoop, DnsNameResolver> resolvers = new HashMap<EventLoop, DnsNameResolver>();
    private final Map<EventLoop, DnsNameResolver> ipv4Resolvers = new HashMap<EventLoop, DnsNameResolver>();
    private final Map<EventLoop, DnsNameResolver> ipv6Resolvers = new HashMap<EventLoop, DnsNameResolver>();
    private final DnsAddressResolverProvider provider;
    private final DnsClientOptions options;
    private final Set<Promise<?>> inflightRequests = ConcurrentHashMap.newKeySet();

    public DnsClientImpl(VertxInternal vertx, DnsClientOptions options) {
        InetSocketAddress dnsServer = new InetSocketAddress(options.getHost(), options.getPort());
        if (dnsServer.isUnresolved()) {
            throw new IllegalArgumentException("Cannot resolve the host to a valid ip address");
        }
        DnsAddressResolverProvider provider = DnsAddressResolverProvider.create(vertx, vertx.nameResolver().options().setServers(Collections.singletonList(dnsServer.getHostString() + ":" + dnsServer.getPort())).setOptResourceEnabled(false));
        this.options = new DnsClientOptions(options);
        this.provider = provider;
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DnsNameResolver resolver(ContextInternal ctx, InternetProtocolFamily ipFamily) {
        DnsNameResolver resolver;
        EventLoop el = ctx.nettyEventLoop();
        DnsClientImpl dnsClientImpl = this;
        synchronized (dnsClientImpl) {
            ResolvedAddressTypes resolvedAddressTypes;
            Map<EventLoop, DnsNameResolver> resolversToUse;
            if (this.closed) {
                return null;
            }
            if (ipFamily == null) {
                resolversToUse = this.resolvers;
                resolvedAddressTypes = ResolvedAddressTypes.IPV4_PREFERRED;
            } else {
                switch (ipFamily) {
                    case IPv4: {
                        resolversToUse = this.ipv4Resolvers;
                        resolvedAddressTypes = ResolvedAddressTypes.IPV4_ONLY;
                        break;
                    }
                    case IPv6: {
                        resolversToUse = this.ipv6Resolvers;
                        resolvedAddressTypes = ResolvedAddressTypes.IPV6_ONLY;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            resolver = resolversToUse.get(el);
            if (resolver == null) {
                DnsNameResolverBuilder builder = this.provider.getDnsNameResolverBuilder();
                builder.resolvedAddressTypes(resolvedAddressTypes);
                builder.queryTimeoutMillis(this.options.getQueryTimeout());
                builder.recursionDesired(this.options.isRecursionDesired());
                resolver = builder.eventLoop(el).build();
                this.ipv4Resolvers.put(el, resolver);
            }
        }
        return resolver;
    }

    @Override
    public Future<@Nullable String> lookup(String name) {
        return this.resolveAll(name, null).map(FIRST_OF);
    }

    @Override
    public Future<@Nullable String> lookup4(String name) {
        return this.resolveAll(name, InternetProtocolFamily.IPv4).map(FIRST_OF);
    }

    @Override
    public Future<@Nullable String> lookup6(String name) {
        return this.resolveAll(name, InternetProtocolFamily.IPv6).map(FIRST_OF);
    }

    @Override
    public Future<List<String>> resolveA(String name) {
        return this.queryAll(name, DnsRecordType.A, RecordDecoder.A);
    }

    @Override
    public Future<List<String>> resolveAAAA(String name) {
        return this.queryAll(name, DnsRecordType.AAAA, RecordDecoder.AAAA);
    }

    @Override
    public Future<List<String>> resolveCNAME(String name) {
        return this.queryAll(name, DnsRecordType.CNAME, RecordDecoder.DOMAIN);
    }

    @Override
    public Future<List<MxRecord>> resolveMX(String name) {
        return this.queryAll(name, DnsRecordType.MX, RecordDecoder.MX);
    }

    @Override
    public Future<List<String>> resolveTXT(String name) {
        return this.queryAll(name, DnsRecordType.TXT, RecordDecoder.TXT).map(lst -> {
            ArrayList res = new ArrayList();
            for (List r : lst) {
                res.addAll(r);
            }
            return res;
        });
    }

    @Override
    public Future<@Nullable String> resolvePTR(String name) {
        return this.queryAll(name, DnsRecordType.PTR, RecordDecoder.DOMAIN).map(FIRST_OF);
    }

    @Override
    public Future<List<String>> resolveNS(String name) {
        return this.queryAll(name, DnsRecordType.NS, RecordDecoder.DOMAIN);
    }

    @Override
    public Future<List<SrvRecord>> resolveSRV(String name) {
        return this.queryAll(name, DnsRecordType.SRV, RecordDecoder.SRV);
    }

    private Future<List<String>> resolveAll(String name, InternetProtocolFamily ipFamily) {
        Objects.requireNonNull(name);
        ContextInternal ctx = this.vertx.getOrCreateContext();
        DnsNameResolver resolver = this.resolver(ctx, ipFamily);
        if (resolver == null) {
            return ctx.failedFuture("DNS client is closed");
        }
        PromiseInternal promise = ctx.promise();
        this.inflightRequests.add(promise);
        io.netty.util.concurrent.Future res = resolver.resolveAll(name);
        res.addListener(future -> {
            if (this.inflightRequests.remove(promise)) {
                if (future.isSuccess()) {
                    promise.complete((List)future.getNow());
                } else {
                    promise.fail(future.cause());
                }
            }
        });
        return promise.future().map(addresses -> {
            ArrayList<String> ret = new ArrayList<String>();
            for (InetAddress inetAddress : addresses) {
                ret.add(inetAddress.getHostAddress());
            }
            return ret;
        });
    }

    private <T> Future<List<T>> queryAll(String name, DnsRecordType recordType, Function<DnsRecord, T> mapper) {
        Objects.requireNonNull(name);
        ContextInternal ctx = this.vertx.getOrCreateContext();
        DnsNameResolver resolver = this.resolver(ctx, InternetProtocolFamily.IPv4);
        if (resolver == null) {
            return ctx.failedFuture("DNS client is closed");
        }
        PromiseInternal promise = ctx.promise();
        this.inflightRequests.add(promise);
        io.netty.util.concurrent.Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> res = resolver.query(new DefaultDnsQuestion(name, recordType));
        res.addListener(future -> {
            if (this.inflightRequests.remove(promise)) {
                if (future.isSuccess()) {
                    promise.complete((AddressedEnvelope)future.getNow());
                } else {
                    promise.fail(future.cause());
                }
            }
        });
        return promise.future().transform(ar -> {
            if (ar.succeeded()) {
                AddressedEnvelope lst = (AddressedEnvelope)ar.result();
                try {
                    DnsResponse content = (DnsResponse)lst.content();
                    DnsResponseCode code = DnsResponseCode.valueOf(content.code().intValue());
                    if (code != DnsResponseCode.NOERROR) {
                        Future future = Future.failedFuture(new DnsException(code));
                        return future;
                    }
                    ArrayList ret = new ArrayList();
                    int cnt = content.count(DnsSection.ANSWER);
                    Object nameToMatch = name.endsWith(".") ? name : name + ".";
                    for (int i = 0; i < cnt; ++i) {
                        Object mapped;
                        Object record = content.recordAt(DnsSection.ANSWER, i);
                        if (!record.name().equals(nameToMatch) || (mapped = mapper.apply((DnsRecord)record)) == null) continue;
                        ret.add(mapped);
                    }
                    Future future = Future.succeededFuture(ret);
                    return future;
                }
                finally {
                    lst.release();
                }
            }
            return (Future)ar;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        DnsClientImpl dnsClientImpl = this;
        synchronized (dnsClientImpl) {
            if (!this.closed) {
                this.closed = true;
                for (Map map : Arrays.asList(this.resolvers, this.ipv4Resolvers, this.ipv6Resolvers)) {
                    ArrayList values = new ArrayList(map.values());
                    map.clear();
                    for (DnsNameResolver resolver : values) {
                        resolver.close();
                    }
                }
                for (Promise promise : this.inflightRequests) {
                    promise.tryFail(new VertxException("closed"));
                }
            }
        }
        return Future.succeededFuture();
    }
}

