/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DuplicatedContext;
import io.vertx.core.impl.EventExecutor;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerExecutor;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.WorkerTask;
import io.vertx.core.impl.WorkerTaskQueue;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public final class ContextImpl
extends ContextBase
implements ContextInternal {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    private final ThreadingModel threadingModel;
    private final VertxInternal owner;
    private final JsonObject config;
    private final Deployment deployment;
    private final CloseFuture closeFuture;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    private final EventExecutor executor;
    private ConcurrentMap<Object, Object> data;
    private volatile Handler<Throwable> exceptionHandler;
    final TaskQueue internalOrderedTasks;
    final WorkerPool internalWorkerPool;
    final WorkerPool workerPool;
    final WorkerTaskQueue executeBlockingTasks;

    static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.onComplete(resultHandler);
        } else {
            fut.onFailure(ctx::reportException);
        }
    }

    public ContextImpl(VertxInternal vertx, int localsLength, ThreadingModel threadingModel, EventLoop eventLoop, EventExecutor executor, WorkerPool internalWorkerPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(localsLength);
        this.threadingModel = threadingModel;
        this.deployment = deployment;
        this.config = deployment != null ? deployment.config() : new JsonObject();
        this.eventLoop = eventLoop;
        this.executor = executor;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.closeFuture = closeFuture;
        this.internalWorkerPool = internalWorkerPool;
        this.executeBlockingTasks = new WorkerTaskQueue();
        this.internalOrderedTasks = new TaskQueue();
    }

    @Override
    public Future<Void> close() {
        Future<Object> fut = this.closeFuture == this.owner.closeFuture() ? Future.succeededFuture() : this.closeFuture.close();
        fut = fut.eventually(() -> Future.future(p -> this.executeBlockingTasks.shutdown(this.eventLoop, (Promise<Void>)p)));
        if (this.executor instanceof WorkerExecutor) {
            WorkerExecutor workerExec = (WorkerExecutor)this.executor;
            fut = fut.eventually(() -> Future.future(p -> workerExec.taskQueue().shutdown(this.eventLoop, (Promise<Void>)p)));
        }
        return fut;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    @Override
    public VertxInternal owner() {
        return this.owner;
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Callable<T> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Callable<T> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, (TaskQueue)(ordered ? this.executeBlockingTasks : null));
    }

    @Override
    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, (TaskQueue)(ordered ? this.executeBlockingTasks : null));
    }

    @Override
    public EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isEventLoopContext() {
        return this.threadingModel == ThreadingModel.EVENT_LOOP;
    }

    @Override
    public boolean isWorkerContext() {
        return this.threadingModel == ThreadingModel.WORKER;
    }

    @Override
    public ThreadingModel threadingModel() {
        return this.threadingModel;
    }

    @Override
    public boolean inThread() {
        return this.executor.inThread();
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    @Override
    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Callable<T> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextImpl.internalExecuteBlocking(context, promise -> {
            Object result;
            try {
                result = blockingCodeHandler.call();
            }
            catch (Throwable e) {
                promise.fail(e);
                return;
            }
            promise.complete(result);
        }, workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextImpl.internalExecuteBlocking(context, promise -> {
            try {
                blockingCodeHandler.handle((Promise)promise);
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, workerPool, queue);
    }

    private static <T> Future<T> internalExecuteBlocking(final ContextInternal context, final Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        final PoolMetrics metrics = workerPool.metrics();
        final Object queueMetric = metrics != null ? metrics.submitted() : null;
        final PromiseInternal promise = context.promise();
        Future fut = promise.future();
        WorkerTask task = new WorkerTask(metrics, queueMetric){

            @Override
            protected void execute() {
                context.dispatch(promise, blockingCodeHandler);
            }

            @Override
            void reject() {
                if (metrics != null) {
                    metrics.rejected(queueMetric);
                }
                promise.fail(new RejectedExecutionException());
            }
        };
        try {
            ExecutorService exec = workerPool.executor();
            if (queue != null) {
                queue.execute(task, exec);
            } else {
                exec.execute(task);
            }
        }
        catch (RejectedExecutionException e) {
            task.reject();
        }
        return fut;
    }

    @Override
    public VertxTracer tracer() {
        return this.owner.tracer();
    }

    @Override
    public ClassLoader classLoader() {
        return this.tccl;
    }

    @Override
    public WorkerPool workerPool() {
        return this.workerPool;
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<Object, Object>();
        }
        return this.data;
    }

    @Override
    public void reportException(Throwable t2) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t2);
        } else {
            log.error("Unhandled exception", t2);
        }
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        try {
            Executor exec = ctx.executor();
            exec.execute(() -> ctx.dispatch(action));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void execute(Runnable task) {
        this.execute(this, task);
    }

    @Override
    public final <T> void execute(T argument, Handler<T> task) {
        this.execute(this, argument, task);
    }

    protected void execute(ContextInternal ctx, Runnable task) {
        if (this.inThread()) {
            task.run();
        } else {
            this.executor.execute(task);
        }
    }

    protected <T> void execute(ContextInternal ctx, T argument, Handler<T> task) {
        if (this.inThread()) {
            task.handle(argument);
        } else {
            this.executor.execute(() -> task.handle(argument));
        }
    }

    @Override
    public <T> void emit(T argument, Handler<T> task) {
        this.emit(this, argument, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void emit(ContextInternal ctx, T argument, Handler<T> task) {
        if (this.inThread()) {
            ContextInternal prev = ctx.beginDispatch();
            try {
                task.handle(argument);
            }
            catch (Throwable t2) {
                this.reportException(t2);
            }
            finally {
                ctx.endDispatch(prev);
            }
        } else {
            this.executor.execute(() -> this.emit(ctx, argument, task));
        }
    }

    @Override
    public ContextInternal duplicate() {
        return new DuplicatedContext(this);
    }
}

