/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.internal;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.BinaryLog;
import io.etcd.jetcd.shaded.io.grpc.ClientInterceptor;
import io.etcd.jetcd.shaded.io.grpc.CompressorRegistry;
import io.etcd.jetcd.shaded.io.grpc.DecompressorRegistry;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.InternalChannelz;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannel;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannelBuilder;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.NameResolverRegistry;
import io.etcd.jetcd.shaded.io.grpc.ProxyDetector;
import io.etcd.jetcd.shaded.io.grpc.internal.ClientTransportFactory;
import io.etcd.jetcd.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.FixedObjectPool;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.ManagedChannelImpl;
import io.etcd.jetcd.shaded.io.grpc.internal.ManagedChannelOrphanWrapper;
import io.etcd.jetcd.shaded.io.grpc.internal.ObjectPool;
import io.etcd.jetcd.shaded.io.grpc.internal.OverrideAuthorityNameResolverFactory;
import io.etcd.jetcd.shaded.io.grpc.internal.SharedResourcePool;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ManagedChannelImplBuilder
extends ManagedChannelBuilder<ManagedChannelImplBuilder> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    private static final Logger log = Logger.getLogger(ManagedChannelImplBuilder.class.getName());
    @VisibleForTesting
    static final long IDLE_MODE_MAX_TIMEOUT_DAYS = 30L;
    @VisibleForTesting
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    private static final long DEFAULT_RETRY_BUFFER_SIZE_IN_BYTES = 0x1000000L;
    private static final long DEFAULT_PER_RPC_BUFFER_LIMIT_IN_BYTES = 0x100000L;
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    ObjectPool<? extends Executor> offloadExecutorPool = DEFAULT_EXECUTOR_POOL;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    final NameResolverRegistry nameResolverRegistry = NameResolverRegistry.getDefaultRegistry();
    private NameResolver.Factory nameResolverFactory = this.nameResolverRegistry.asFactory();
    final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    String userAgent;
    @Nullable
    private String authorityOverride;
    String defaultLbPolicy = "pick_first";
    boolean fullStreamDecompression;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    int maxRetryAttempts = 5;
    int maxHedgedAttempts = 5;
    long retryBufferSize = 0x1000000L;
    long perRpcBufferLimit = 0x100000L;
    boolean retryEnabled = false;
    boolean temporarilyDisableRetry;
    InternalChannelz channelz = InternalChannelz.instance();
    int maxTraceEvents;
    @Nullable
    Map<String, ?> defaultServiceConfig;
    boolean lookUpServiceConfig = true;
    @Nullable
    BinaryLog binlog;
    @Nullable
    ProxyDetector proxyDetector;
    private boolean authorityCheckerDisabled;
    private boolean statsEnabled = true;
    private boolean recordStartedRpcs = true;
    private boolean recordFinishedRpcs = true;
    private boolean recordRealTimeMetrics = false;
    private boolean tracingEnabled = true;
    private final ClientTransportFactoryBuilder clientTransportFactoryBuilder;
    private final ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider;

    public static ManagedChannelBuilder<?> forAddress(String name, int port) {
        throw new UnsupportedOperationException("ClientTransportFactoryBuilder is required, use a constructor");
    }

    public static ManagedChannelBuilder<?> forTarget(String target) {
        throw new UnsupportedOperationException("ClientTransportFactoryBuilder is required, use a constructor");
    }

    public ManagedChannelImplBuilder(String target, ClientTransportFactoryBuilder clientTransportFactoryBuilder, @Nullable ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.clientTransportFactoryBuilder = Preconditions.checkNotNull(clientTransportFactoryBuilder, "clientTransportFactoryBuilder");
        this.directServerAddress = null;
        this.channelBuilderDefaultPortProvider = channelBuilderDefaultPortProvider != null ? channelBuilderDefaultPortProvider : new ManagedChannelDefaultPortProvider();
    }

    @VisibleForTesting
    static String makeTargetStringForDirectAddress(SocketAddress address) {
        try {
            return new URI(DIRECT_ADDRESS_SCHEME, "", "/" + address, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ManagedChannelImplBuilder(SocketAddress directServerAddress, String authority, ClientTransportFactoryBuilder clientTransportFactoryBuilder, @Nullable ChannelBuilderDefaultPortProvider channelBuilderDefaultPortProvider) {
        this.target = ManagedChannelImplBuilder.makeTargetStringForDirectAddress(directServerAddress);
        this.clientTransportFactoryBuilder = Preconditions.checkNotNull(clientTransportFactoryBuilder, "clientTransportFactoryBuilder");
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
        this.channelBuilderDefaultPortProvider = channelBuilderDefaultPortProvider != null ? channelBuilderDefaultPortProvider : new ManagedChannelDefaultPortProvider();
    }

    @Override
    public ManagedChannelImplBuilder directExecutor() {
        return this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public ManagedChannelImplBuilder executor(Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder offloadExecutor(Executor executor) {
        this.offloadExecutorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this;
    }

    @Override
    public ManagedChannelImplBuilder intercept(ClientInterceptor ... interceptors) {
        return this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    @Deprecated
    public ManagedChannelImplBuilder nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object)this.directServerAddress);
        this.nameResolverFactory = resolverFactory != null ? resolverFactory : this.nameResolverRegistry.asFactory();
        return this;
    }

    @Override
    public ManagedChannelImplBuilder defaultLoadBalancingPolicy(String policy) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of load-balancing policy", (Object)this.directServerAddress);
        Preconditions.checkArgument(policy != null, "policy cannot be null");
        this.defaultLbPolicy = policy;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder enableFullStreamDecompression() {
        this.fullStreamDecompression = true;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry != null ? registry : DEFAULT_DECOMPRESSOR_REGISTRY;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry != null ? registry : DEFAULT_COMPRESSOR_REGISTRY;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder userAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this;
    }

    @Nullable
    @VisibleForTesting
    String getOverrideAuthority() {
        return this.authorityOverride;
    }

    @Override
    public ManagedChannelImplBuilder idleTimeout(long value, TimeUnit unit) {
        Preconditions.checkArgument(value > 0L, "idle timeout is %s, but must be positive", value);
        this.idleTimeoutMillis = unit.toDays(value) >= 30L ? -1L : Math.max(unit.toMillis(value), IDLE_MODE_MIN_TIMEOUT_MILLIS);
        return this;
    }

    @Override
    public ManagedChannelImplBuilder maxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder maxHedgedAttempts(int maxHedgedAttempts) {
        this.maxHedgedAttempts = maxHedgedAttempts;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder retryBufferSize(long bytes) {
        Preconditions.checkArgument(bytes > 0L, "retry buffer size must be positive");
        this.retryBufferSize = bytes;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder perRpcBufferLimit(long bytes) {
        Preconditions.checkArgument(bytes > 0L, "per RPC buffer limit must be positive");
        this.perRpcBufferLimit = bytes;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder disableRetry() {
        this.retryEnabled = false;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder enableRetry() {
        this.retryEnabled = true;
        this.statsEnabled = false;
        this.tracingEnabled = false;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder setBinaryLog(BinaryLog binlog) {
        this.binlog = binlog;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder maxTraceEvents(int maxTraceEvents) {
        Preconditions.checkArgument(maxTraceEvents >= 0, "maxTraceEvents must be non-negative");
        this.maxTraceEvents = maxTraceEvents;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder proxyDetector(@Nullable ProxyDetector proxyDetector) {
        this.proxyDetector = proxyDetector;
        return this;
    }

    @Override
    public ManagedChannelImplBuilder defaultServiceConfig(@Nullable Map<String, ?> serviceConfig) {
        this.defaultServiceConfig = ManagedChannelImplBuilder.checkMapEntryTypes(serviceConfig);
        return this;
    }

    @Nullable
    private static Map<String, ?> checkMapEntryTypes(@Nullable Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> parsedMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Preconditions.checkArgument(entry.getKey() instanceof String, "The key of the entry '%s' is not of String type", entry);
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                parsedMap.put(key, null);
                continue;
            }
            if (value instanceof Map) {
                parsedMap.put(key, ManagedChannelImplBuilder.checkMapEntryTypes((Map)value));
                continue;
            }
            if (value instanceof List) {
                parsedMap.put(key, ManagedChannelImplBuilder.checkListEntryTypes((List)value));
                continue;
            }
            if (value instanceof String) {
                parsedMap.put(key, value);
                continue;
            }
            if (value instanceof Double) {
                parsedMap.put(key, value);
                continue;
            }
            if (value instanceof Boolean) {
                parsedMap.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("The value of the map entry '" + entry + "' is of type '" + value.getClass() + "', which is not supported");
        }
        return Collections.unmodifiableMap(parsedMap);
    }

    private static List<?> checkListEntryTypes(List<?> list) {
        ArrayList<Object> parsedList = new ArrayList<Object>(list.size());
        for (Object value : list) {
            if (value == null) {
                parsedList.add(null);
                continue;
            }
            if (value instanceof Map) {
                parsedList.add(ManagedChannelImplBuilder.checkMapEntryTypes((Map)value));
                continue;
            }
            if (value instanceof List) {
                parsedList.add(ManagedChannelImplBuilder.checkListEntryTypes((List)value));
                continue;
            }
            if (value instanceof String) {
                parsedList.add(value);
                continue;
            }
            if (value instanceof Double) {
                parsedList.add(value);
                continue;
            }
            if (value instanceof Boolean) {
                parsedList.add(value);
                continue;
            }
            throw new IllegalArgumentException("The entry '" + value + "' is of type '" + value.getClass() + "', which is not supported");
        }
        return Collections.unmodifiableList(parsedList);
    }

    @Override
    public ManagedChannelImplBuilder disableServiceConfigLookUp() {
        this.lookUpServiceConfig = false;
        return this;
    }

    public void setStatsEnabled(boolean value) {
        this.statsEnabled = value;
    }

    public void setStatsRecordStartedRpcs(boolean value) {
        this.recordStartedRpcs = value;
    }

    public void setStatsRecordFinishedRpcs(boolean value) {
        this.recordFinishedRpcs = value;
    }

    public void setStatsRecordRealTimeMetrics(boolean value) {
        this.recordRealTimeMetrics = value;
    }

    public void setTracingEnabled(boolean value) {
        this.tracingEnabled = value;
    }

    @VisibleForTesting
    String checkAuthority(String authority) {
        if (this.authorityCheckerDisabled) {
            return authority;
        }
        return GrpcUtil.checkAuthority(authority);
    }

    public ManagedChannelImplBuilder disableCheckAuthority() {
        this.authorityCheckerDisabled = true;
        return this;
    }

    public ManagedChannelImplBuilder enableCheckAuthority() {
        this.authorityCheckerDisabled = false;
        return this;
    }

    @Override
    public ManagedChannel build() {
        return new ManagedChannelOrphanWrapper(new ManagedChannelImpl(this, this.clientTransportFactoryBuilder.buildClientTransportFactory(), new ExponentialBackoffPolicy.Provider(), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.getEffectiveInterceptors(), TimeProvider.SYSTEM_TIME_PROVIDER));
    }

    @VisibleForTesting
    List<ClientInterceptor> getEffectiveInterceptors() {
        ArrayList<ClientInterceptor> effectiveInterceptors = new ArrayList<ClientInterceptor>(this.interceptors);
        this.temporarilyDisableRetry = false;
        if (this.statsEnabled) {
            this.temporarilyDisableRetry = true;
            ClientInterceptor statsInterceptor = null;
            try {
                Class<?> censusStatsAccessor = Class.forName("io.etcd.jetcd.shaded.io.grpc.census.InternalCensusStatsAccessor");
                Method getClientInterceptorMethod = censusStatsAccessor.getDeclaredMethod("getClientInterceptor", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                statsInterceptor = (ClientInterceptor)getClientInterceptorMethod.invoke(null, this.recordStartedRpcs, this.recordFinishedRpcs, this.recordRealTimeMetrics);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            if (statsInterceptor != null) {
                effectiveInterceptors.add(0, statsInterceptor);
            }
        }
        if (this.tracingEnabled) {
            this.temporarilyDisableRetry = true;
            ClientInterceptor tracingInterceptor = null;
            try {
                Class<?> censusTracingAccessor = Class.forName("io.etcd.jetcd.shaded.io.grpc.census.InternalCensusTracingAccessor");
                Method getClientInterceptroMethod = censusTracingAccessor.getDeclaredMethod("getClientInterceptor", new Class[0]);
                tracingInterceptor = (ClientInterceptor)getClientInterceptroMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.FINE, "Unable to apply census stats", e);
            }
            if (tracingInterceptor != null) {
                effectiveInterceptors.add(0, tracingInterceptor);
            }
        }
        return effectiveInterceptors;
    }

    int getDefaultPort() {
        return this.channelBuilderDefaultPortProvider.getDefaultPort();
    }

    NameResolver.Factory getNameResolverFactory() {
        if (this.authorityOverride == null) {
            return this.nameResolverFactory;
        }
        return new OverrideAuthorityNameResolverFactory(this.nameResolverFactory, this.authorityOverride);
    }

    public ObjectPool<? extends Executor> getOffloadExecutorPool() {
        return this.offloadExecutorPool;
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, NameResolver.Args args) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener2 listener) {
                    listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(Collections.singletonList(new EquivalentAddressGroup(DirectAddressNameResolverFactory.this.address))).setAttributes(Attributes.EMPTY).build());
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return ManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static final class ManagedChannelDefaultPortProvider
    implements ChannelBuilderDefaultPortProvider {
        private ManagedChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return 443;
        }
    }

    public static final class FixedPortProvider
    implements ChannelBuilderDefaultPortProvider {
        private final int port;

        public FixedPortProvider(int port) {
            this.port = port;
        }

        @Override
        public int getDefaultPort() {
            return this.port;
        }
    }

    public static interface ChannelBuilderDefaultPortProvider {
        public int getDefaultPort();
    }

    public static class UnsupportedClientTransportFactoryBuilder
    implements ClientTransportFactoryBuilder {
        @Override
        public ClientTransportFactory buildClientTransportFactory() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ClientTransportFactoryBuilder {
        public ClientTransportFactory buildClientTransportFactory();
    }
}

