/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.base.Splitter;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.SharedResourceHolder;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.GuardedBy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsSrvNameResolver
extends NameResolver {
    public static final String SCHEME = "dns+srv";
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsSrvNameResolver.class);
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();
    private final Object lock = new Object();
    private final String authority;
    private final URI targetUri;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private Executor executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public DnsSrvNameResolver(URI targetUri) {
        this.targetUri = targetUri;
        this.authority = targetUri.getAuthority() != null ? targetUri.getAuthority() : SCHEME;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.listener == null, "already started");
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = Preconditions.checkNotNull(listener, "listener");
            this.resolve();
        }
    }

    @Override
    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            ArrayList<EquivalentAddressGroup> groups = new ArrayList<EquivalentAddressGroup>();
            for (SocketAddress address : this.resolveAddresses()) {
                groups.add(new EquivalentAddressGroup(address, io.etcd.jetcd.shaded.io.grpc.Attributes.EMPTY));
            }
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.targetUri);
            }
            savedListener.onAddresses(groups, io.etcd.jetcd.shaded.io.grpc.Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }

    private List<SocketAddress> resolveAddresses() {
        LinkedList<SocketAddress> addresses = new LinkedList<SocketAddress>();
        try {
            String address = this.targetUri.getPath();
            if (address.startsWith("/")) {
                address = address.substring(1);
            }
            InitialDirContext ctx = new InitialDirContext(ENV);
            Attributes attributes = ctx.getAttributes(address, ATTRIBUTE_IDS);
            NamingEnumeration<?> resolved = attributes.get("srv").getAll();
            while (resolved.hasMore()) {
                String record = (String)resolved.next();
                List<String> split = Splitter.on(' ').splitToList(record);
                if (split.size() < 4) continue;
                String host = split.get(3).trim();
                String port = split.get(2).trim();
                addresses.add(new InetSocketAddress(host, Integer.parseInt(port)));
            }
        }
        catch (Exception e) {
            throw EtcdExceptionFactory.toEtcdException(e);
        }
        return addresses;
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

