/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeFuture;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Fallback;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

class FallbackExecutor
extends PolicyExecutor<Fallback> {
    FallbackExecutor(Fallback fallback, AbstractExecution execution) {
        super(fallback, execution);
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        try {
            return this.policy == Fallback.VOID ? result.withNonResult() : result.withResult(((Fallback)this.policy).apply(result.getResult(), result.getFailure(), this.execution.copy()));
        }
        catch (Exception e) {
            return ExecutionResult.failure(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult> onFailureAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<Object> future) {
        CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
        Callable<Object> callable = () -> {
            try {
                CompletableFuture<Object> fallback = ((Fallback)this.policy).applyStage(result.getResult(), result.getFailure(), this.execution.copy());
                fallback.whenComplete((innerResult, failure) -> {
                    if (failure instanceof CompletionException) {
                        failure = failure.getCause();
                    }
                    ExecutionResult r = failure == null ? result.withResult(innerResult) : ExecutionResult.failure(failure);
                    promise.complete(r);
                });
            }
            catch (Exception e) {
                promise.complete(ExecutionResult.failure(e));
            }
            return null;
        };
        try {
            if (!((Fallback)this.policy).isAsync()) {
                callable.call();
            } else {
                future.inject(scheduler.schedule(callable, result.getWaitNanos(), TimeUnit.NANOSECONDS));
            }
        }
        catch (Throwable t) {
            promise.completeExceptionally(t);
        }
        return promise;
    }
}

