/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.AbstractExecution;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class FailsafeFuture<T>
extends CompletableFuture<T> {
    private final FailsafeExecutor<T> executor;
    private AbstractExecution execution;
    private Future<T> delegate;
    private List<Future<T>> timeoutDelegates;

    FailsafeFuture(FailsafeExecutor<T> executor) {
        this.executor = executor;
    }

    @Override
    public synchronized boolean complete(T value) {
        return this.completeResult(ExecutionResult.success(value));
    }

    @Override
    public synchronized boolean completeExceptionally(Throwable failure) {
        return this.completeResult(ExecutionResult.failure(failure));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean cancelResult = super.cancel(mayInterruptIfRunning);
        cancelResult = this.cancelDelegates(mayInterruptIfRunning, cancelResult);
        ExecutionResult result = ExecutionResult.failure(new CancellationException());
        super.completeExceptionally(result.getFailure());
        this.executor.handleComplete(result, this.execution);
        return cancelResult;
    }

    synchronized boolean completeResult(ExecutionResult result) {
        if (this.isDone()) {
            return false;
        }
        Throwable failure = result.getFailure();
        boolean completed = failure == null ? super.complete(result.getResult()) : super.completeExceptionally(failure);
        if (completed) {
            this.executor.handleComplete(result, this.execution);
        }
        return completed;
    }

    synchronized Future<T> getDelegate() {
        return this.delegate;
    }

    synchronized boolean cancelDelegates(boolean interruptDelegate, boolean result) {
        this.execution.cancelled = true;
        this.execution.interrupted = interruptDelegate;
        if (this.delegate != null) {
            result = this.delegate.cancel(interruptDelegate);
        }
        if (this.timeoutDelegates != null) {
            for (Future<T> timeoutDelegate : this.timeoutDelegates) {
                timeoutDelegate.cancel(false);
            }
            this.timeoutDelegates.clear();
        }
        return result;
    }

    synchronized List<Future<T>> getTimeoutDelegates() {
        return this.timeoutDelegates;
    }

    synchronized void inject(Future<T> delegate) {
        this.delegate = delegate;
        if (this.timeoutDelegates != null) {
            this.timeoutDelegates.clear();
        }
    }

    synchronized void injectTimeout(Future<T> timeoutDelegate) {
        if (this.timeoutDelegates == null) {
            this.timeoutDelegates = new ArrayList<Future<T>>(3);
        }
        this.timeoutDelegates.add(timeoutDelegate);
    }

    void inject(AbstractExecution execution) {
        this.execution = execution;
    }
}

