/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe.internal;

import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionContext;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.event.ExecutionAttemptedEvent;
import io.etcd.jetcd.shaded.net.jodah.failsafe.event.ExecutionCompletedEvent;
import io.etcd.jetcd.shaded.net.jodah.failsafe.event.ExecutionScheduledEvent;
import io.etcd.jetcd.shaded.net.jodah.failsafe.function.CheckedConsumer;
import java.time.Duration;

public interface EventListener {
    public void handle(ExecutionResult var1, ExecutionContext var2);

    public static <R> EventListener of(CheckedConsumer<? extends ExecutionCompletedEvent<R>> handler) {
        return (result, context) -> {
            try {
                handler.accept(new ExecutionCompletedEvent<Object>(result.getResult(), result.getFailure(), context.copy()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    public static <R> EventListener ofAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> handler) {
        return (result, context) -> {
            try {
                handler.accept(new ExecutionAttemptedEvent<Object>(result.getResult(), result.getFailure(), context.copy()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    public static <R> EventListener ofScheduled(CheckedConsumer<? extends ExecutionScheduledEvent<R>> handler) {
        return (result, context) -> {
            try {
                handler.accept(new ExecutionScheduledEvent<Object>(result.getResult(), result.getFailure(), Duration.ofNanos(result.getWaitNanos()), context.copy()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }
}

