/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.auth.AuthInterceptor;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.collect.Iterables;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.etcd.jetcd.shaded.io.grpc.CallOptions;
import io.etcd.jetcd.shaded.io.grpc.Channel;
import io.etcd.jetcd.shaded.io.grpc.ClientCall;
import io.etcd.jetcd.shaded.io.grpc.ClientInterceptor;
import io.etcd.jetcd.shaded.io.grpc.ForwardingClientCall;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannel;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannelBuilder;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.MethodDescriptor;
import io.etcd.jetcd.shaded.io.grpc.netty.NegotiationType;
import io.etcd.jetcd.shaded.io.grpc.netty.NettyChannelBuilder;
import io.etcd.jetcd.shaded.io.grpc.stub.AbstractStub;
import io.etcd.jetcd.shaded.io.netty.channel.ChannelOption;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Failsafe;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Policy;
import io.etcd.jetcd.shaded.net.jodah.failsafe.RetryPolicy;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionManager.class);
    private final Object lock = new Object();
    private final ClientBuilder builder;
    private final ExecutorService executorService;
    private final AuthInterceptor authInterceptor;
    private volatile ManagedChannel managedChannel;

    ClientConnectionManager(ClientBuilder builder) {
        this(builder, null);
    }

    ClientConnectionManager(ClientBuilder builder, ManagedChannel managedChannel) {
        this.builder = builder;
        this.authInterceptor = new AuthInterceptor(builder);
        this.managedChannel = managedChannel;
        this.executorService = builder.executorService() == null ? Executors.newCachedThreadPool() : builder.executorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        if (this.managedChannel == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managedChannel == null) {
                    this.managedChannel = this.defaultChannelBuilder().build();
                }
            }
        }
        return this.managedChannel;
    }

    ByteSequence getNamespace() {
        return this.builder.namespace();
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    AuthInterceptor authInterceptor() {
        return this.authInterceptor;
    }

    <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> supplier) {
        return this.newStub(supplier, this.getChannel());
    }

    private <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> stubCustomizer, ManagedChannel channel) {
        AbstractStub stub = (AbstractStub)stubCustomizer.apply(channel);
        if (this.builder.waitForReady()) {
            return (T)stub.withWaitForReady();
        }
        return (T)stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.managedChannel != null) {
                this.managedChannel.shutdownNow();
            }
        }
        if (this.builder.executorService() == null) {
            this.executorService.shutdownNow();
        }
    }

    <T extends AbstractStub<T>, R> CompletableFuture<R> withNewChannel(URI endpoint, Function<ManagedChannel, T> stubCustomizer, Function<T, CompletableFuture<R>> stubConsumer) {
        ManagedChannel channel = this.defaultChannelBuilder(Collections.singletonList(endpoint)).build();
        T stub = this.newStub(stubCustomizer, channel);
        try {
            return stubConsumer.apply(stub).whenComplete((r, t) -> channel.shutdown());
        }
        catch (Exception e) {
            channel.shutdown();
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }

    @VisibleForTesting
    protected ManagedChannelBuilder<?> defaultChannelBuilder() {
        return this.defaultChannelBuilder(this.builder.endpoints());
    }

    @VisibleForTesting
    protected ManagedChannelBuilder<?> defaultChannelBuilder(Collection<URI> endpoints) {
        String target;
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("At least one endpoint should be provided");
        }
        if (this.builder.discovery()) {
            if (endpoints.size() != 1) {
                throw new IllegalArgumentException("When configured for discovery, there should be only a single endpoint");
            }
            target = String.format("%s:///%s", "dns+srv", Iterables.get(endpoints, 0));
        } else {
            target = String.format("%s://%s/%s", "ip", this.builder.authority() != null ? this.builder.authority() : "", endpoints.stream().map(e -> e.getHost() + ":" + e.getPort()).collect(Collectors.joining(",")));
        }
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget(target);
        if (this.builder.authority() != null) {
            channelBuilder.overrideAuthority(this.builder.authority());
        }
        if (this.builder.maxInboundMessageSize() != null) {
            channelBuilder.maxInboundMessageSize(this.builder.maxInboundMessageSize());
        }
        if (this.builder.sslContext() != null) {
            channelBuilder.negotiationType(NegotiationType.TLS);
            channelBuilder.sslContext(this.builder.sslContext());
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        if (this.builder.keepaliveTime() != null) {
            channelBuilder.keepAliveTime(this.builder.keepaliveTime().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveTimeout() != null) {
            channelBuilder.keepAliveTimeout(this.builder.keepaliveTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveWithoutCalls() != null) {
            channelBuilder.keepAliveWithoutCalls(this.builder.keepaliveWithoutCalls());
        }
        if (this.builder.connectTimeout() != null) {
            channelBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)this.builder.connectTimeout().toMillis());
        }
        if (this.builder.loadBalancerPolicy() != null) {
            channelBuilder.defaultLoadBalancingPolicy(this.builder.loadBalancerPolicy());
        } else {
            channelBuilder.defaultLoadBalancingPolicy("pick_first");
        }
        channelBuilder.intercept(new ClientInterceptor[]{this.authInterceptor});
        if (this.builder.headers() != null) {
            channelBuilder.intercept(new ClientInterceptor[]{new ClientInterceptor(){

                @Override
                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                        @Override
                        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                            ClientConnectionManager.this.builder.headers().forEach(headers::put);
                            super.start(responseListener, headers);
                        }
                    };
                }
            }});
        }
        if (this.builder.interceptors() != null) {
            channelBuilder.intercept((List)this.builder.interceptors());
        }
        return channelBuilder;
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert) {
        return this.execute(task, resultConvert, Util::isRetryable);
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert, Predicate<Throwable> doRetry) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(doRetry)).onRetriesExceeded(e -> LOGGER.warn("maximum number of auto retries reached")).withBackoff(this.builder.retryDelay(), this.builder.retryMaxDelay(), this.builder.retryChronoUnit());
        if (this.builder.retryMaxDuration() != null) {
            retryPolicy = retryPolicy.withMaxDuration(this.builder.retryMaxDuration());
        }
        return Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).with(this.executorService).getAsyncExecution(execution -> {
            CompletableFuture wrappedFuture = new CompletableFuture();
            ListenableFuture future = (ListenableFuture)task.call();
            future.addListener(() -> {
                block2: {
                    try {
                        wrappedFuture.complete(future.get());
                        execution.complete(wrappedFuture);
                    }
                    catch (Exception error) {
                        if (execution.retryOn(error)) break block2;
                        wrappedFuture.completeExceptionally(error);
                    }
                }
            }, this.executorService);
        }).thenCompose(f -> f.thenApply(resultConvert));
    }
}

