/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.net.jodah.failsafe;

import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionContext;
import io.etcd.jetcd.shaded.net.jodah.failsafe.ExecutionResult;
import io.etcd.jetcd.shaded.net.jodah.failsafe.FailsafeExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.Policy;
import io.etcd.jetcd.shaded.net.jodah.failsafe.PolicyExecutor;
import io.etcd.jetcd.shaded.net.jodah.failsafe.internal.util.Assert;
import io.etcd.jetcd.shaded.net.jodah.failsafe.util.concurrent.Scheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractExecution
extends ExecutionContext {
    final Scheduler scheduler;
    final FailsafeExecutor<Object> executor;
    final List<PolicyExecutor<Policy<Object>>> policyExecutors;
    volatile boolean resultHandled;
    volatile boolean canInterrupt;
    volatile boolean interrupted;
    volatile long waitNanos;
    volatile boolean completed;

    AbstractExecution(Scheduler scheduler, FailsafeExecutor<Object> executor) {
        this.scheduler = scheduler;
        this.executor = executor;
        this.policyExecutors = new ArrayList<PolicyExecutor<Policy<Object>>>(executor.policies.size());
        ListIterator policyIterator = executor.policies.listIterator(executor.policies.size());
        int i = 1;
        while (policyIterator.hasPrevious()) {
            PolicyExecutor policyExecutor = policyIterator.previous().toExecutor(this);
            policyExecutor.policyIndex = i++;
            this.policyExecutors.add(policyExecutor);
        }
    }

    void record(ExecutionResult result) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        if (!this.interrupted) {
            this.attempts.incrementAndGet();
            this.lastResult = result.getResult();
            this.lastFailure = result.getFailure();
        }
    }

    void preExecute() {
        this.attemptStartTime = Duration.ofNanos(System.nanoTime());
        if (this.startTime == Duration.ZERO) {
            this.startTime = this.attemptStartTime;
        }
        this.resultHandled = false;
        this.cancelledIndex = 0;
        this.canInterrupt = true;
        this.interrupted = false;
    }

    boolean isAsyncExecution() {
        return false;
    }

    synchronized ExecutionResult postExecute(ExecutionResult result) {
        this.record(result);
        boolean allComplete = true;
        for (PolicyExecutor<Policy<Object>> policyExecutor : this.policyExecutors) {
            result = policyExecutor.postExecute(result);
            allComplete = allComplete && result.isComplete();
        }
        this.waitNanos = result.getWaitNanos();
        this.completed = allComplete;
        return result;
    }

    public Duration getWaitTime() {
        return Duration.ofNanos(this.waitNanos);
    }

    public boolean isComplete() {
        return this.completed;
    }
}

