/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.stub;

import io.etcd.jetcd.shaded.com.google.common.base.MoreObjects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.AbstractFuture;
import io.etcd.jetcd.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.etcd.jetcd.shaded.io.grpc.CallOptions;
import io.etcd.jetcd.shaded.io.grpc.Channel;
import io.etcd.jetcd.shaded.io.grpc.ClientCall;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.MethodDescriptor;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.StatusException;
import io.etcd.jetcd.shaded.io.grpc.StatusRuntimeException;
import io.etcd.jetcd.shaded.io.grpc.stub.ClientCallStreamObserver;
import io.etcd.jetcd.shaded.io.grpc.stub.ClientResponseObserver;
import io.etcd.jetcd.shaded.io.grpc.stub.StreamObserver;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClientCalls {
    private static final Logger logger = Logger.getLogger(ClientCalls.class.getName());
    static final CallOptions.Key<StubType> STUB_TYPE_OPTION = CallOptions.Key.create("internal-stub-type");

    private ClientCalls() {
    }

    public static <ReqT, RespT> void asyncUnaryCall(ClientCall<ReqT, RespT> call, ReqT req, StreamObserver<RespT> responseObserver) {
        ClientCalls.asyncUnaryRequestCall(call, req, responseObserver, false);
    }

    public static <ReqT, RespT> void asyncServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT req, StreamObserver<RespT> responseObserver) {
        ClientCalls.asyncUnaryRequestCall(call, req, responseObserver, true);
    }

    public static <ReqT, RespT> StreamObserver<ReqT> asyncClientStreamingCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        return ClientCalls.asyncStreamingRequestCall(call, responseObserver, false);
    }

    public static <ReqT, RespT> StreamObserver<ReqT> asyncBidiStreamingCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver) {
        return ClientCalls.asyncStreamingRequestCall(call, responseObserver, true);
    }

    public static <ReqT, RespT> RespT blockingUnaryCall(ClientCall<ReqT, RespT> call, ReqT req) {
        try {
            return ClientCalls.getUnchecked(ClientCalls.futureUnaryCall(call, req));
        }
        catch (RuntimeException e) {
            throw ClientCalls.cancelThrow(call, e);
        }
        catch (Error e) {
            throw ClientCalls.cancelThrow(call, e);
        }
    }

    public static <ReqT, RespT> RespT blockingUnaryCall(Channel channel, MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, ReqT req) {
        ThreadlessExecutor executor = new ThreadlessExecutor();
        boolean interrupt = false;
        ClientCall<ReqT, RespT> call = channel.newCall(method, callOptions.withExecutor(executor));
        try {
            ListenableFuture<RespT> responseFuture = ClientCalls.futureUnaryCall(call, req);
            while (!responseFuture.isDone()) {
                try {
                    executor.waitAndDrain();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                    call.cancel("Thread interrupted", e);
                }
            }
            RespT RespT = ClientCalls.getUnchecked(responseFuture);
            return RespT;
        }
        catch (RuntimeException e) {
            throw ClientCalls.cancelThrow(call, e);
        }
        catch (Error e) {
            throw ClientCalls.cancelThrow(call, e);
        }
        finally {
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(ClientCall<ReqT, RespT> call, ReqT req) {
        BlockingResponseStream<RespT> result = new BlockingResponseStream<RespT>(call);
        ClientCalls.asyncUnaryRequestCall(call, req, result.listener(), true);
        return result;
    }

    public static <ReqT, RespT> Iterator<RespT> blockingServerStreamingCall(Channel channel, MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, ReqT req) {
        ThreadlessExecutor executor = new ThreadlessExecutor();
        ClientCall<ReqT, RespT> call = channel.newCall(method, callOptions.withExecutor(executor));
        BlockingResponseStream<RespT> result = new BlockingResponseStream<RespT>(call, executor);
        ClientCalls.asyncUnaryRequestCall(call, req, result.listener(), true);
        return result;
    }

    public static <ReqT, RespT> ListenableFuture<RespT> futureUnaryCall(ClientCall<ReqT, RespT> call, ReqT req) {
        GrpcFuture<RespT> responseFuture = new GrpcFuture<RespT>(call);
        ClientCalls.asyncUnaryRequestCall(call, req, new UnaryStreamToFuture<RespT>(responseFuture), false);
        return responseFuture;
    }

    private static <V> V getUnchecked(Future<V> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Status.CANCELLED.withDescription("Thread interrupted").withCause(e).asRuntimeException();
        }
        catch (ExecutionException e) {
            throw ClientCalls.toStatusRuntimeException(e.getCause());
        }
    }

    private static StatusRuntimeException toStatusRuntimeException(Throwable t) {
        for (Throwable cause = Preconditions.checkNotNull(t, "t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException se = (StatusException)cause;
                return new StatusRuntimeException(se.getStatus(), se.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException se = (StatusRuntimeException)cause;
            return new StatusRuntimeException(se.getStatus(), se.getTrailers());
        }
        return Status.UNKNOWN.withDescription("unexpected exception").withCause(t).asRuntimeException();
    }

    private static RuntimeException cancelThrow(ClientCall<?, ?> call, Throwable t) {
        try {
            call.cancel(null, t);
        }
        catch (Throwable e) {
            assert (e instanceof RuntimeException || e instanceof Error);
            logger.log(Level.SEVERE, "RuntimeException encountered while closing call", e);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new AssertionError((Object)t);
    }

    private static <ReqT, RespT> void asyncUnaryRequestCall(ClientCall<ReqT, RespT> call, ReqT req, StreamObserver<RespT> responseObserver, boolean streamingResponse) {
        ClientCalls.asyncUnaryRequestCall(call, req, new StreamObserverToCallListenerAdapter<ReqT, RespT>(responseObserver, new CallToStreamObserverAdapter<ReqT>(call), streamingResponse), streamingResponse);
    }

    private static <ReqT, RespT> void asyncUnaryRequestCall(ClientCall<ReqT, RespT> call, ReqT req, ClientCall.Listener<RespT> responseListener, boolean streamingResponse) {
        ClientCalls.startCall(call, responseListener, streamingResponse);
        try {
            call.sendMessage(req);
            call.halfClose();
        }
        catch (RuntimeException e) {
            throw ClientCalls.cancelThrow(call, e);
        }
        catch (Error e) {
            throw ClientCalls.cancelThrow(call, e);
        }
    }

    private static <ReqT, RespT> StreamObserver<ReqT> asyncStreamingRequestCall(ClientCall<ReqT, RespT> call, StreamObserver<RespT> responseObserver, boolean streamingResponse) {
        CallToStreamObserverAdapter<ReqT> adapter = new CallToStreamObserverAdapter<ReqT>(call);
        ClientCalls.startCall(call, new StreamObserverToCallListenerAdapter<ReqT, RespT>(responseObserver, adapter, streamingResponse), streamingResponse);
        return adapter;
    }

    private static <ReqT, RespT> void startCall(ClientCall<ReqT, RespT> call, ClientCall.Listener<RespT> responseListener, boolean streamingResponse) {
        call.start(responseListener, new Metadata());
        if (streamingResponse) {
            call.request(1);
        } else {
            call.request(2);
        }
    }

    static enum StubType {
        BLOCKING,
        FUTURE,
        ASYNC;

    }

    private static final class ThreadlessExecutor
    extends ConcurrentLinkedQueue<Runnable>
    implements Executor {
        private static final Logger log = Logger.getLogger(ThreadlessExecutor.class.getName());
        private volatile Thread waiter;

        ThreadlessExecutor() {
        }

        public void waitAndDrain() throws InterruptedException {
            ThreadlessExecutor.throwIfInterrupted();
            Runnable runnable = (Runnable)this.poll();
            if (runnable == null) {
                this.waiter = Thread.currentThread();
                try {
                    while ((runnable = (Runnable)this.poll()) == null) {
                        LockSupport.park(this);
                        ThreadlessExecutor.throwIfInterrupted();
                    }
                }
                finally {
                    this.waiter = null;
                }
            }
            do {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "Runnable threw exception", t);
                }
            } while ((runnable = (Runnable)this.poll()) != null);
        }

        private static void throwIfInterrupted() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.add(runnable);
            LockSupport.unpark(this.waiter);
        }
    }

    private static final class BlockingResponseStream<T>
    implements Iterator<T> {
        private final BlockingQueue<Object> buffer = new ArrayBlockingQueue<Object>(2);
        private final ClientCall.Listener<T> listener = new QueuingListener();
        private final ClientCall<?, T> call;
        private final ThreadlessExecutor threadless;
        private Object last;

        BlockingResponseStream(ClientCall<?, T> call) {
            this(call, null);
        }

        BlockingResponseStream(ClientCall<?, T> call, ThreadlessExecutor threadless) {
            this.call = call;
            this.threadless = threadless;
        }

        ClientCall.Listener<T> listener() {
            return this.listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object waitForNext() {
            Object next;
            boolean interrupt;
            block11: {
                interrupt = false;
                if (this.threadless != null) break block11;
                while (true) {
                    try {
                        Object object = this.buffer.take();
                        return object;
                    }
                    catch (InterruptedException ie) {
                        interrupt = true;
                        this.call.cancel("Thread interrupted", ie);
                        continue;
                    }
                    break;
                }
            }
            while ((next = this.buffer.poll()) == null) {
                try {
                    this.threadless.waitAndDrain();
                }
                catch (InterruptedException ie) {
                    interrupt = true;
                    this.call.cancel("Thread interrupted", ie);
                }
            }
            Object e = next;
            return e;
            finally {
                if (interrupt) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.last == null) {
                this.last = this.waitForNext();
            }
            if (this.last instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)this.last;
                throw e.getStatus().asRuntimeException(e.getTrailers());
            }
            return this.last != this;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object tmp;
                this.call.request(1);
                Object object = tmp = this.last;
                return (T)object;
            }
            finally {
                this.last = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final class QueuingListener
        extends ClientCall.Listener<T> {
            private boolean done = false;

            QueuingListener() {
            }

            @Override
            public void onHeaders(Metadata headers) {
            }

            @Override
            public void onMessage(T value) {
                Preconditions.checkState(!this.done, "ClientCall already closed");
                BlockingResponseStream.this.buffer.add(value);
            }

            @Override
            public void onClose(Status status, Metadata trailers) {
                Preconditions.checkState(!this.done, "ClientCall already closed");
                if (status.isOk()) {
                    BlockingResponseStream.this.buffer.add(BlockingResponseStream.this);
                } else {
                    BlockingResponseStream.this.buffer.add(status.asRuntimeException(trailers));
                }
                this.done = true;
            }
        }
    }

    private static final class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        private final ClientCall<?, RespT> call;

        GrpcFuture(ClientCall<?, RespT> call) {
            this.call = call;
        }

        @Override
        protected void interruptTask() {
            this.call.cancel("GrpcFuture was cancelled", null);
        }

        @Override
        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        @Override
        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        @Override
        protected String pendingToString() {
            return MoreObjects.toStringHelper(this).add("clientCall", this.call).toString();
        }
    }

    private static final class UnaryStreamToFuture<RespT>
    extends ClientCall.Listener<RespT> {
        private final GrpcFuture<RespT> responseFuture;
        private RespT value;

        UnaryStreamToFuture(GrpcFuture<RespT> responseFuture) {
            this.responseFuture = responseFuture;
        }

        @Override
        public void onHeaders(Metadata headers) {
        }

        @Override
        public void onMessage(RespT value) {
            if (this.value != null) {
                throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = value;
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            if (status.isOk()) {
                if (this.value == null) {
                    this.responseFuture.setException(Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException(trailers));
                }
                this.responseFuture.set(this.value);
            } else {
                this.responseFuture.setException(status.asRuntimeException(trailers));
            }
        }
    }

    private static final class StreamObserverToCallListenerAdapter<ReqT, RespT>
    extends ClientCall.Listener<RespT> {
        private final StreamObserver<RespT> observer;
        private final CallToStreamObserverAdapter<ReqT> adapter;
        private final boolean streamingResponse;
        private boolean firstResponseReceived;

        StreamObserverToCallListenerAdapter(StreamObserver<RespT> observer, CallToStreamObserverAdapter<ReqT> adapter, boolean streamingResponse) {
            this.observer = observer;
            this.streamingResponse = streamingResponse;
            this.adapter = adapter;
            if (observer instanceof ClientResponseObserver) {
                ClientResponseObserver clientResponseObserver = (ClientResponseObserver)observer;
                clientResponseObserver.beforeStart(adapter);
            }
            ((CallToStreamObserverAdapter)adapter).freeze();
        }

        @Override
        public void onHeaders(Metadata headers) {
        }

        @Override
        public void onMessage(RespT message) {
            if (this.firstResponseReceived && !this.streamingResponse) {
                throw Status.INTERNAL.withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
            }
            this.firstResponseReceived = true;
            this.observer.onNext(message);
            if (this.streamingResponse && ((CallToStreamObserverAdapter)this.adapter).autoFlowControlEnabled) {
                this.adapter.request(1);
            }
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            if (status.isOk()) {
                this.observer.onCompleted();
            } else {
                this.observer.onError(status.asRuntimeException(trailers));
            }
        }

        @Override
        public void onReady() {
            if (((CallToStreamObserverAdapter)this.adapter).onReadyHandler != null) {
                ((CallToStreamObserverAdapter)this.adapter).onReadyHandler.run();
            }
        }
    }

    private static final class CallToStreamObserverAdapter<T>
    extends ClientCallStreamObserver<T> {
        private boolean frozen;
        private final ClientCall<T, ?> call;
        private Runnable onReadyHandler;
        private boolean autoFlowControlEnabled = true;
        private boolean aborted = false;
        private boolean completed = false;

        CallToStreamObserverAdapter(ClientCall<T, ?> call) {
            this.call = call;
        }

        private void freeze() {
            this.frozen = true;
        }

        @Override
        public void onNext(T value) {
            Preconditions.checkState(!this.aborted, "Stream was terminated by error, no further calls are allowed");
            Preconditions.checkState(!this.completed, "Stream is already completed, no further calls are allowed");
            this.call.sendMessage(value);
        }

        @Override
        public void onError(Throwable t) {
            this.call.cancel("Cancelled by client with StreamObserver.onError()", t);
            this.aborted = true;
        }

        @Override
        public void onCompleted() {
            this.call.halfClose();
            this.completed = true;
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        @Override
        public void setOnReadyHandler(Runnable onReadyHandler) {
            if (this.frozen) {
                throw new IllegalStateException("Cannot alter onReadyHandler after call started. Use ClientResponseObserver");
            }
            this.onReadyHandler = onReadyHandler;
        }

        @Override
        public void disableAutoInboundFlowControl() {
            if (this.frozen) {
                throw new IllegalStateException("Cannot disable auto flow control after call started. Use ClientResponseObserver");
            }
            this.autoFlowControlEnabled = false;
        }

        @Override
        public void request(int count) {
            this.call.request(count);
        }

        @Override
        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }

        @Override
        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            this.call.cancel(message, cause);
        }
    }
}

